/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class ScriptRunner
implements AutoCloseable {
    protected static final String PUBLIC = "PUBLIC";
    private static final String COMMENT = "--";
    private static final char QUOTE = '\'';
    private static final char IDENTIFIER_QUOTE = '\"';
    private static final char END_OF_STATEMENT = ';';
    private static final String ESCAPE = "$BODY$";
    private final Dialect dialect;
    private final Map<String, String> replacements = new HashMap<String, String>();
    protected final String identifierQuote;
    protected final boolean isEnumTypeSupported;
    protected final boolean isCatalogSupported;
    protected final boolean isSchemaSupported;
    protected final boolean isGrantOnSchemaSupported;
    protected final boolean isGrantOnTableSupported;
    protected final boolean isCommentSupported;
    protected final boolean isCreateLanguageRequired;
    private final int maxRowsPerInsert;
    private final Statement statement;
    private Matcher statementsToSkip;
    private StringBuilder regexOfStmtToSkip;
    private String currentFile;
    private int currentLine;
    private String currentSQL;

    public ScriptRunner(Connection connection, int n) throws SQLException {
        ArgumentChecks.ensureNonNull("connection", connection);
        ArgumentChecks.ensurePositive("maxRowsPerInsert", n);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.maxRowsPerInsert = n;
        this.dialect = Dialect.guess(databaseMetaData);
        this.identifierQuote = databaseMetaData.getIdentifierQuoteString();
        this.isSchemaSupported = databaseMetaData.supportsSchemasInTableDefinitions() && databaseMetaData.supportsSchemasInDataManipulation();
        this.isCatalogSupported = databaseMetaData.supportsCatalogsInTableDefinitions() && databaseMetaData.supportsCatalogsInDataManipulation();
        this.statement = connection.createStatement();
        switch (this.dialect) {
            default: {
                this.isEnumTypeSupported = false;
                this.isGrantOnSchemaSupported = false;
                this.isGrantOnTableSupported = false;
                this.isCreateLanguageRequired = false;
                this.isCommentSupported = false;
                break;
            }
            case POSTGRESQL: {
                int n2 = databaseMetaData.getDatabaseMajorVersion();
                this.isEnumTypeSupported = n2 == 8 ? databaseMetaData.getDatabaseMinorVersion() >= 4 : n2 >= 8;
                this.isGrantOnSchemaSupported = true;
                this.isGrantOnTableSupported = true;
                this.isCreateLanguageRequired = n2 < 9;
                this.isCommentSupported = true;
                break;
            }
            case HSQL: {
                this.isEnumTypeSupported = false;
                this.isGrantOnSchemaSupported = false;
                this.isGrantOnTableSupported = false;
                this.isCreateLanguageRequired = false;
                this.isCommentSupported = false;
                this.statement.execute("SET DATABASE DEFAULT TABLE TYPE CACHED");
            }
        }
        if (!this.isEnumTypeSupported) {
            this.addStatementToSkip("CREATE\\s+(?:TYPE|CAST)\\s+.*");
        }
        if (!this.isGrantOnSchemaSupported || !this.isGrantOnTableSupported) {
            this.addStatementToSkip("GRANT\\s+\\w+\\s+ON\\s+");
            if (this.isGrantOnSchemaSupported) {
                this.regexOfStmtToSkip.append("TABLE");
            } else if (this.isGrantOnTableSupported) {
                this.regexOfStmtToSkip.append("SCHEMA");
            } else {
                this.regexOfStmtToSkip.append("(?:TABLE|SCHEMA)");
            }
            this.regexOfStmtToSkip.append("\\s+.*");
        }
        if (!this.isCommentSupported) {
            this.addStatementToSkip("COMMENT\\s+ON\\s+.*");
        }
    }

    protected final Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    protected final void addStatementToSkip(String string) {
        if (this.statementsToSkip != null) {
            throw new IllegalStateException();
        }
        if (this.regexOfStmtToSkip == null) {
            this.regexOfStmtToSkip = new StringBuilder(string);
        } else {
            this.regexOfStmtToSkip.append('|').append(string);
        }
    }

    protected final void addReplacement(String string, String string2) {
        if (this.replacements.put(string, string2) != null) {
            throw new IllegalArgumentException(string);
        }
    }

    protected final String getReplacement(String string) {
        return this.replacements.getOrDefault(string, string);
    }

    protected final void modifyReplacements(BiFunction<String, String, String> biFunction) {
        this.replacements.replaceAll(biFunction);
    }

    public final int run(String string) throws IOException, SQLException {
        return this.run(null, new LineNumberReader(new StringReader(string)));
    }

    public final int run(Class<?> clazz, String string) throws IOException, SQLException {
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(clazz.getResourceAsStream(string), "UTF-8"));){
            int n = this.run(string, lineNumberReader);
            return n;
        }
    }

    public final int run(String string, BufferedReader bufferedReader) throws IOException, SQLException {
        String string2;
        this.currentFile = string;
        this.currentLine = 0;
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        block5: while ((string2 = bufferedReader.readLine()) != null) {
            int n3;
            if (stringBuilder.length() == 0) {
                n3 = CharSequences.skipLeadingWhitespaces(string2, 0, string2.length());
                if (n3 >= string2.length() || string2.regionMatches(n3, COMMENT, 0, COMMENT.length())) continue;
                if (bufferedReader instanceof LineNumberReader) {
                    this.currentLine = ((LineNumberReader)bufferedReader).getLineNumber();
                }
            } else {
                stringBuilder.append('\n');
            }
            n3 = string2.indexOf(ESCAPE);
            if (n3 >= 0) {
                n3 += ESCAPE.length();
                while ((n3 = string2.indexOf(ESCAPE, n3)) < 0) {
                    stringBuilder.append(string2).append('\n');
                    string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        throw new EOFException();
                    }
                    n3 = 0;
                }
                stringBuilder.append(string2, 0, n3 += ESCAPE.length());
                string2 = string2.substring(n3);
            }
            n3 = stringBuilder.length();
            int n4 = stringBuilder.append(string2).length();
            block7: while (n3 < n4) {
                int n5 = stringBuilder.codePointAt(n3);
                int n6 = Character.charCount(n5);
                if (n2 < 0 && !bl) {
                    int n7 = n3;
                    while (Character.isUnicodeIdentifierStart(n5)) {
                        String string3;
                        String string4;
                        while ((n3 += n6) < n4) {
                            n5 = stringBuilder.codePointAt(n3);
                            n6 = Character.charCount(n5);
                            if (Character.isUnicodeIdentifierPart(n5)) continue;
                        }
                        if ((string4 = this.replacements.get(string3 = stringBuilder.substring(n7, n3))) != null) {
                            n4 = stringBuilder.replace(n7, n3, string4).length();
                            n3 = n7 + string4.length();
                        }
                        if (n3 >= n4) continue block5;
                        while (Character.isWhitespace(n5)) {
                            if ((n3 += n6) >= n4) continue block5;
                            n5 = stringBuilder.codePointAt(n3);
                            n6 = Character.charCount(n5);
                        }
                        n7 = n3;
                    }
                }
                switch (n5) {
                    case 34: {
                        if (n2 >= 0) break;
                        bl = !bl;
                        n4 = stringBuilder.replace(n3, n3 + n6, this.identifierQuote).length();
                        n6 = this.identifierQuote.length();
                        break;
                    }
                    case 39: {
                        if (bl) break;
                        if (n2 < 0) {
                            n2 = n3;
                            break;
                        }
                        if ((n3 += n6) < n4 && stringBuilder.codePointAt(n3) == 39) break;
                        this.editText(stringBuilder, n2, n3);
                        int n8 = n4;
                        n4 = stringBuilder.length();
                        n3 -= n8 - n4;
                        n2 = -1;
                        continue block7;
                    }
                    case 59: {
                        if (n2 >= 0 || bl) break;
                        if (CharSequences.skipLeadingWhitespaces(stringBuilder, n3 + n6, n4) >= n4) {
                            stringBuilder.setLength(n3);
                        }
                        n += this.execute(stringBuilder);
                        stringBuilder.setLength(0);
                        continue block5;
                    }
                }
                n3 += n6;
            }
        }
        string2 = stringBuilder.toString().trim();
        if (!string2.isEmpty() && !string2.startsWith(COMMENT)) {
            throw new EOFException(Errors.format((short)138, string2));
        }
        this.currentFile = null;
        return n;
    }

    protected void editText(StringBuilder stringBuilder, int n, int n2) {
    }

    private static boolean isOutsideQuotes(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            switch (charSequence.charAt(n++)) {
                case '\"': {
                    ++n4;
                    break;
                }
                case '\'': {
                    if (n3 & true && n < n2 && charSequence.charAt(n) == '\'') {
                        ++n;
                        break;
                    }
                    ++n3;
                }
            }
        }
        return !((n3 | n4) & true);
    }

    protected boolean isSupported(CharSequence charSequence) {
        if (this.statementsToSkip != null) {
            return !this.statementsToSkip.reset(charSequence).matches();
        }
        if (this.regexOfStmtToSkip != null) {
            this.statementsToSkip = Pattern.compile(this.regexOfStmtToSkip.toString(), 32).matcher(charSequence);
            this.regexOfStmtToSkip = null;
            return !this.statementsToSkip.matches();
        }
        return true;
    }

    protected int execute(StringBuilder stringBuilder) throws SQLException, IOException {
        int n;
        if (!this.isSupported(stringBuilder)) {
            return 0;
        }
        String string = this.currentSQL = CharSequences.trimWhitespaces(stringBuilder).toString();
        if (!this.dialect.isTableInheritanceSupported && string.startsWith("CREATE TABLE") && (n = stringBuilder.lastIndexOf("INHERITS")) >= 0 && ScriptRunner.isOutsideQuotes(stringBuilder, n + 8, stringBuilder.length())) {
            stringBuilder.setLength(CharSequences.skipTrailingWhitespaces(stringBuilder, 0, n));
            string = this.currentSQL = stringBuilder.toString();
        }
        n = 0;
        if (string.startsWith("SELECT ")) {
            this.statement.executeQuery(string).close();
        } else {
            if (this.maxRowsPerInsert != Integer.MAX_VALUE && string.startsWith("INSERT INTO")) {
                if (this.maxRowsPerInsert == 0) {
                    string = null;
                } else {
                    int n2 = string.indexOf(10, 11);
                    if (string.regionMatches(n2 - 6, "VALUES", 0, 6)) {
                        int n3;
                        stringBuilder.setLength(0);
                        int n4 = stringBuilder.append(string, 0, n2).append(' ').length();
                        int n5 = this.maxRowsPerInsert;
                        int n6 = n2 + 1;
                        while (true) {
                            ++n2;
                            if ((n2 = string.indexOf(10, n2)) < 0) break;
                            if (--n5 != 0) continue;
                            n3 = n2;
                            if (string.charAt(n3 - 1) == ',') {
                                --n3;
                            }
                            this.currentSQL = stringBuilder.append(string, n6, n3).toString();
                            n += this.statement.executeUpdate(this.currentSQL);
                            stringBuilder.setLength(n4);
                            n5 = this.maxRowsPerInsert;
                            n6 = n2 + 1;
                        }
                        n3 = CharSequences.skipTrailingWhitespaces(string, n6, string.length());
                        string = n3 > n6 ? stringBuilder.append(string, n6, n3).toString() : null;
                        this.currentSQL = string;
                    }
                }
            }
            if (string != null) {
                n += this.statement.executeUpdate(string);
            }
        }
        this.currentSQL = null;
        return n;
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    public String status(Locale locale) {
        String string = null;
        if (this.currentFile != null) {
            string = Errors.getResources(locale).getString((short)33, this.currentFile, this.currentLine != 0 ? this.currentLine : 63);
        }
        if (this.currentSQL != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string).append('\n');
            }
            string = stringBuilder.append("SQL: ").append(this.currentSQL).toString();
        }
        return string;
    }

    public String toString() {
        return this.status(null);
    }
}

