/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.util.Map;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.feature.jts.GeometryCoordinateTransform;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS
extends Static {
    public static final String CRS_KEY = "CRS";

    private JTS() {
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Geometry geometry) throws FactoryException {
        if (geometry != null) {
            Map map;
            Object v;
            Object object = geometry.getUserData();
            if (object instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)object;
            }
            if (object instanceof Map && (v = (map = (Map)object).get(CRS_KEY)) instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)v;
            }
            int n = geometry.getSRID();
            if (n > 0) {
                return CRS.forCode("EPSG:" + n);
            }
        }
        return null;
    }

    private static CoordinateOperation findOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Geometry geometry) throws FactoryException {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
        try {
            Envelope envelope = geometry.getEnvelopeInternal();
            defaultGeographicBoundingBox.setBounds(new Envelope2D(coordinateReferenceSystem, envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight()));
        }
        catch (TransformException transformException) {
            defaultGeographicBoundingBox = null;
            Logging.ignorableException(Logging.getLogger("org.apache.sis.geometry"), JTS.class, "transform", transformException);
        }
        return CRS.findOperation(coordinateReferenceSystem, coordinateReferenceSystem2, defaultGeographicBoundingBox);
    }

    public static Geometry transform(Geometry geometry, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
        if (geometry != null && coordinateReferenceSystem != null) {
            CoordinateReferenceSystem coordinateReferenceSystem2 = JTS.getCoordinateReferenceSystem(geometry);
            if (coordinateReferenceSystem2 == null) {
                throw new TransformException(Errors.format((short)157));
            }
            if (!Utilities.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                geometry = JTS.transform(geometry, JTS.findOperation(coordinateReferenceSystem2, coordinateReferenceSystem, geometry));
            }
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, CoordinateOperation coordinateOperation) throws FactoryException, TransformException {
        if (geometry != null && coordinateOperation != null) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
            if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = JTS.getCoordinateReferenceSystem(geometry)) != null && !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                coordinateOperation = JTS.findOperation(coordinateReferenceSystem, coordinateOperation.getTargetCRS(), geometry);
            }
            geometry = JTS.transform(geometry, coordinateOperation.getMathTransform());
            geometry.setUserData((Object)coordinateOperation.getTargetCRS());
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, MathTransform mathTransform) throws TransformException {
        if (geometry != null && mathTransform != null && !mathTransform.isIdentity()) {
            GeometryCoordinateTransform geometryCoordinateTransform = new GeometryCoordinateTransform(mathTransform, geometry.getFactory());
            geometry = geometryCoordinateTransform.transform(geometry);
        }
        return geometry;
    }
}

