/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

final class MultiBandsIndexColorModel
extends IndexColorModel {
    final int numBands;
    final int visibleBand;

    public MultiBandsIndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5, int n6, int n7) {
        super(n, n2, nArray, n3, bl, n4, n5);
        this.numBands = n6;
        this.visibleBand = n7;
    }

    @Override
    public Object getDataElements(int n, Object object) {
        if (object == null) {
            switch (this.transferType) {
                case 1: 
                case 2: {
                    object = new short[this.numBands];
                    break;
                }
                case 0: {
                    object = new byte[this.numBands];
                    break;
                }
                case 3: {
                    object = new int[this.numBands];
                }
            }
        }
        object = super.getDataElements(n, object);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                Arrays.fill(byArray, 1, this.numBands, byArray[0]);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                Arrays.fill(sArray, 1, this.numBands, sArray[0]);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                Arrays.fill(nArray, 1, this.numBands, nArray[0]);
                break;
            }
        }
        return object;
    }

    private int pixel(Object object) {
        switch (this.transferType) {
            case 0: {
                return Byte.toUnsignedInt(((byte[])object)[this.visibleBand]);
            }
            case 1: {
                return Short.toUnsignedInt(((short[])object)[this.visibleBand]);
            }
            case 2: {
                return ((short[])object)[this.visibleBand];
            }
            case 3: {
                return ((int[])object)[this.visibleBand];
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getComponents(Object object, int[] nArray, int n) {
        return this.getComponents(this.pixel(nArray), nArray, n);
    }

    @Override
    public int getRed(Object object) {
        return this.getRed(this.pixel(object));
    }

    @Override
    public int getGreen(Object object) {
        return this.getGreen(this.pixel(object));
    }

    @Override
    public int getBlue(Object object) {
        return this.getBlue(this.pixel(object));
    }

    @Override
    public int getAlpha(Object object) {
        return this.getAlpha(this.pixel(object));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return Raster.createBandedRaster(this.transferType, n, n2, this.numBands, null);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new BandedSampleModel(this.transferType, n, n2, this.numBands);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel && sampleModel.getTransferType() == this.transferType && sampleModel.getNumBands() == this.numBands && 1 << sampleModel.getSampleSize(this.visibleBand) >= this.getMapSize();
    }
}

