/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Ellipsoid;

public class CoordinateFormat
extends CompoundFormat<DirectPosition> {
    private static final long serialVersionUID = 8324486673169133932L;
    private static final int READ_AHEAD_LIMIT = 256;
    private static final int DEFAULT_DIMENSION = 4;
    private String separator = " ";
    private String parseSeparator = " ";
    private CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private transient byte[] types;
    private transient Format[] formats;
    private transient Unit<?>[] units;
    private transient UnitConverter[] toFormatUnit;
    private transient String[] unitSymbols;
    private transient long negate;
    private transient long[] epochs;
    private transient FieldPosition dummy;
    private transient StringBuffer buffer;

    public CoordinateFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
    }

    public CoordinateFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        ArgumentChecks.ensureNonEmpty("separator", string);
        this.separator = string;
        this.parseSeparator = CharSequences.trimWhitespaces(string);
        if (this.parseSeparator.isEmpty()) {
            this.parseSeparator = string;
        }
    }

    public CoordinateReferenceSystem getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.defaultCRS = coordinateReferenceSystem;
    }

    private void initialize(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.types = null;
        this.formats = null;
        this.units = null;
        this.toFormatUnit = null;
        this.unitSymbols = null;
        this.epochs = null;
        this.negate = 0L;
        this.lastCRS = coordinateReferenceSystem;
        if (coordinateReferenceSystem == null) {
            return;
        }
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        if (coordinateSystem == null) {
            return;
        }
        int n = coordinateSystem.getDimension();
        byte[] byArray = new byte[n];
        Format[] formatArray = new Format[n];
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (coordinateSystemAxis == null) {
                formatArray[i] = this.getFormat(Number.class);
                continue;
            }
            Unit<?> unit = coordinateSystemAxis.getUnit();
            if (Units.isAngular(unit)) {
                int n2 = 3;
                AxisDirection axisDirection = coordinateSystemAxis.getDirection();
                if (AxisDirection.NORTH.equals(axisDirection)) {
                    n2 = 2;
                } else if (AxisDirection.EAST.equals(axisDirection)) {
                    n2 = 1;
                } else if (AxisDirection.SOUTH.equals(axisDirection)) {
                    n2 = 2;
                    this.negate(i);
                } else if (AxisDirection.WEST.equals(axisDirection)) {
                    n2 = 1;
                    this.negate(i);
                }
                byArray[i] = n2;
                formatArray[i] = this.getFormat(org.apache.sis.measure.Angle.class);
                this.setConverter(n, i, unit.asType(Angle.class).getConverterTo(Units.DEGREE));
                continue;
            }
            if (Units.isTemporal(unit)) {
                CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.getComponentAt(coordinateReferenceSystem, i, i + 1);
                if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                    if (this.epochs == null) {
                        this.epochs = new long[n];
                    }
                    byArray[i] = 4;
                    formatArray[i] = this.getFormat(Date.class);
                    this.epochs[i] = ((TemporalCRS)coordinateReferenceSystem2).getDatum().getOrigin().getTime();
                    this.setConverter(n, i, unit.asType(Time.class).getConverterTo(Units.MILLISECOND));
                    if (!AxisDirection.PAST.equals(coordinateSystemAxis.getDirection())) continue;
                    this.negate(i);
                    continue;
                }
                byArray[i] = 5;
            }
            formatArray[i] = this.getFormat(Number.class);
            if (unit == null) continue;
            if (this.units == null) {
                this.units = new Unit[n];
            }
            this.units[i] = unit;
            String string = this.getFormat(Unit.class).format(unit);
            if (string.isEmpty()) continue;
            if (this.unitSymbols == null) {
                this.unitSymbols = new String[n];
            }
            this.unitSymbols[i] = string;
        }
        this.types = byArray;
        this.formats = formatArray;
    }

    private void setConverter(int n, int n2, UnitConverter unitConverter) {
        if (!unitConverter.isIdentity()) {
            if (this.toFormatUnit == null) {
                this.toFormatUnit = new UnitConverter[n];
            }
            this.toFormatUnit[n2] = unitConverter;
        }
    }

    private void negate(int n) {
        if (n >= 64) {
            throw new ArithmeticException(Errors.format((short)37, n));
        }
        this.negate |= 1L << n;
    }

    private boolean isNegative(int n) {
        return (this.negate & Numerics.bitmask(n)) != 0L;
    }

    public void setPrecision(double d, Unit<?> unit) {
        CoordinateSystem coordinateSystem;
        ArgumentChecks.ensureFinite("resolution", d);
        ArgumentChecks.ensureNonNull("unit", unit);
        d = Math.abs(d);
        if (Units.isTemporal(unit)) {
            return;
        }
        Resolution resolution = new Resolution(d, unit, Units.isAngular(unit));
        Resolution resolution2 = null;
        IncommensurableException incommensurableException = null;
        if (resolution.isAngular || Units.isLinear(unit)) {
            try {
                resolution2 = resolution.related(ReferencingUtilities.getEllipsoid(this.defaultCRS));
            }
            catch (IncommensurableException incommensurableException2) {
                incommensurableException = incommensurableException2;
            }
        }
        boolean bl = false;
        if (this.defaultCRS != null && (coordinateSystem = this.defaultCRS.getCoordinateSystem()) != null) {
            int n = coordinateSystem.getDimension();
            for (int i = 0; i < n; ++i) {
                Unit<?> unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                if (coordinateSystemAxis == null || (unit2 = coordinateSystemAxis.getUnit()) == null) continue;
                try {
                    double d2 = Math.max(Math.abs(coordinateSystemAxis.getMinimumValue()), Math.abs(coordinateSystemAxis.getMaximumValue()));
                    if (resolution.forAxis(d2, unit2) || resolution2 == null) continue;
                    bl |= resolution2.forAxis(d2, unit2);
                    continue;
                }
                catch (IncommensurableException incommensurableException3) {
                    if (incommensurableException == null) {
                        incommensurableException = incommensurableException3;
                        continue;
                    }
                    incommensurableException.addSuppressed(incommensurableException3);
                }
            }
        }
        if (incommensurableException != null) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.measure"), CoordinateFormat.class, "setPrecision", incommensurableException);
        }
        resolution.setPrecision(this);
        if (bl) {
            resolution2.setPrecision(this);
        }
    }

    public String getPattern(Class<?> clazz) {
        Format format = this.getFormat(clazz);
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public boolean applyPattern(Class<?> clazz, String string) {
        ArgumentChecks.ensureNonNull("pattern", string);
        Format format = this.getFormat(clazz);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(string);
        } else if (format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)format).applyPattern(string);
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(string);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public final Class<DirectPosition> getValueType() {
        return DirectPosition.class;
    }

    public String format(DirectPosition directPosition) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        try {
            this.format(directPosition, (Appendable)this.buffer);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return this.buffer.toString();
    }

    @Override
    public void format(DirectPosition directPosition, Appendable appendable) throws IOException {
        StringBuffer stringBuffer;
        ArgumentChecks.ensureNonNull("position", directPosition);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = this.defaultCRS;
        }
        if (coordinateReferenceSystem != this.lastCRS) {
            this.initialize(coordinateReferenceSystem);
        }
        if (appendable instanceof StringBuffer) {
            stringBuffer = (StringBuffer)appendable;
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            stringBuffer = this.buffer;
            stringBuffer.setLength(0);
        }
        if (this.dummy == null) {
            this.dummy = new FieldPosition(0);
        }
        int n = directPosition.getDimension();
        for (int i = 0; i < n; ++i) {
            Comparable<Double> comparable;
            Object object;
            Format format;
            double d = directPosition.getOrdinate(i);
            if (this.formats != null && i < this.formats.length) {
                format = this.formats[i];
                if (this.isNegative(i)) {
                    d = -d;
                }
                if (this.toFormatUnit != null && (object = this.toFormatUnit[i]) != null) {
                    d = object.convert(d);
                }
                switch (this.types[i]) {
                    default: {
                        comparable = d;
                        break;
                    }
                    case 1: {
                        comparable = new Longitude(d);
                        break;
                    }
                    case 2: {
                        comparable = new Latitude(d);
                        break;
                    }
                    case 3: {
                        comparable = new org.apache.sis.measure.Angle(d);
                        break;
                    }
                    case 4: {
                        comparable = new Date(Math.round(d) + this.epochs[i]);
                        break;
                    }
                }
            } else {
                comparable = d;
                format = this.getFormat(Number.class);
            }
            if (i != 0) {
                appendable.append(this.separator);
            }
            if (format.format(comparable, stringBuffer, this.dummy) != appendable) {
                appendable.append(stringBuffer);
                stringBuffer.setLength(0);
            }
            if (this.unitSymbols == null || i >= this.unitSymbols.length || (object = this.unitSymbols[i]) == null) continue;
            appendable.append('\u00a0').append((CharSequence)object);
        }
    }

    @Override
    public DirectPosition parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        double[] dArray;
        Format format;
        Format[] formatArray;
        String string;
        ParsePosition parsePosition2;
        int n;
        ArgumentChecks.ensureNonNull("text", charSequence);
        ArgumentChecks.ensureNonNull("pos", parsePosition);
        int n2 = parsePosition.getIndex();
        int n3 = charSequence.length();
        if (charSequence instanceof String) {
            n = 0;
            parsePosition2 = parsePosition;
            string = (String)charSequence;
        } else {
            n = n2;
            parsePosition2 = new ParsePosition(0);
            string = charSequence.subSequence(n2, Math.min(n2 + 256, n3)).toString();
        }
        if (this.lastCRS != this.defaultCRS) {
            this.initialize(this.defaultCRS);
        }
        if ((formatArray = this.formats) != null) {
            format = null;
            dArray = new double[formatArray.length];
        } else {
            format = this.getFormat(Number.class);
            dArray = new double[4];
        }
        for (int i = 0; i < dArray.length; ++i) {
            Object object;
            Object object2;
            if (i != 0) {
                int n4 = parsePosition2.getIndex();
                int n5 = n + n4;
                while (!CharSequences.regionMatches(charSequence, n5, this.parseSeparator)) {
                    int n6;
                    if (n5 < n3 && Character.isSpaceChar(n6 = Character.codePointAt(charSequence, n5))) {
                        n5 += Character.charCount(n6);
                        continue;
                    }
                    if (formatArray == null) {
                        parsePosition.setIndex(n5);
                        return new GeneralDirectPosition(Arrays.copyOf(dArray, i));
                    }
                    parsePosition.setIndex(n2);
                    parsePosition.setErrorIndex(n5);
                    throw new LocalizedParseException(this.getLocale(), 135, new CharSequence[]{charSequence.subSequence(n2, n4), CharSequences.token(charSequence, n5)}, n5);
                }
                parsePosition2.setIndex(n5 + this.parseSeparator.length() - n);
            }
            if (formatArray != null) {
                format = formatArray[i];
            }
            if ((object2 = format.parseObject(string, parsePosition2)) == null) {
                Class clazz = Number.class;
                if (this.types != null) {
                    switch (this.types[i]) {
                        case 1: {
                            clazz = Longitude.class;
                            break;
                        }
                        case 2: {
                            clazz = Latitude.class;
                            break;
                        }
                        case 3: {
                            clazz = org.apache.sis.measure.Angle.class;
                            break;
                        }
                        case 4: {
                            clazz = Date.class;
                        }
                    }
                }
                parsePosition.setIndex(n2);
                if (parsePosition2 != parsePosition) {
                    parsePosition.setErrorIndex(n + parsePosition2.getErrorIndex());
                }
                throw new LocalizedParseException(this.getLocale(), clazz, charSequence, parsePosition);
            }
            double d = object2 instanceof org.apache.sis.measure.Angle ? ((org.apache.sis.measure.Angle)object2).degrees() : (object2 instanceof Date ? (double)(((Date)object2).getTime() - this.epochs[i]) : ((Number)object2).doubleValue());
            if (this.units != null && (object = this.units[i]) != null) {
                int n7;
                int n8;
                for (int j = n7 = parsePosition2.getIndex(); j < string.length(); j += Character.charCount(n8)) {
                    n8 = string.codePointAt(j);
                    if (Character.isSpaceChar(n8)) {
                        continue;
                    }
                    parsePosition2.setIndex(j);
                    Object object3 = this.getFormat(Unit.class).parseObject(string, parsePosition2);
                    if (object3 == null) {
                        parsePosition2.setIndex(n7);
                        parsePosition2.setErrorIndex(-1);
                        break;
                    }
                    try {
                        d = ((Unit)object3).getConverterToAny((Unit<?>)object).convert(d);
                        break;
                    }
                    catch (IncommensurableException incommensurableException) {
                        parsePosition.setIndex(n2);
                        parsePosition.setErrorIndex(j += n);
                        throw (ParseException)new ParseException(incommensurableException.getMessage(), j).initCause(incommensurableException);
                    }
                }
            }
            if (this.toFormatUnit != null && (object = this.toFormatUnit[i]) != null) {
                d = object.inverse().convert(d);
            }
            if (this.isNegative(i)) {
                d = -d;
            }
            dArray[i] = d;
        }
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(dArray);
        generalDirectPosition.setCoordinateReferenceSystem(this.defaultCRS);
        return generalDirectPosition;
    }

    @Override
    public CoordinateFormat clone() {
        CoordinateFormat coordinateFormat = (CoordinateFormat)super.clone();
        coordinateFormat.dummy = null;
        coordinateFormat.buffer = null;
        Format[] formatArray = coordinateFormat.formats;
        if (formatArray != null) {
            coordinateFormat.formats = formatArray = (Format[])formatArray.clone();
            for (int i = 0; i < formatArray.length; ++i) {
                formatArray[i] = (Format)formatArray[i].clone();
            }
        }
        return coordinateFormat;
    }

    private static final class Resolution {
        private double resolution;
        private double magnitude;
        private Unit<?> unit;
        final boolean isAngular;

        Resolution(double d, Unit<?> unit, boolean bl) {
            this.resolution = d;
            this.unit = unit;
            this.isAngular = bl;
        }

        Resolution related(Ellipsoid ellipsoid) throws IncommensurableException {
            Unit<Quantity<Length>> unit;
            double d = Formulas.getAuthalicRadius(ellipsoid);
            if (d > 0.0 && (unit = ellipsoid.getAxisUnit()) != null) {
                double d2;
                if (this.isAngular) {
                    d2 = this.unit.getConverterToAny(Units.RADIAN).convert(this.resolution) * d;
                } else {
                    d2 = Math.toDegrees(this.unit.getConverterToAny(unit).convert(this.resolution) / d);
                    unit = Units.DEGREE;
                }
                return new Resolution(d2, unit, !this.isAngular);
            }
            return null;
        }

        boolean forAxis(double d, Unit<?> unit) throws IncommensurableException {
            if (!unit.isCompatible(this.unit)) {
                return false;
            }
            UnitConverter unitConverter = this.unit.getConverterToAny(unit);
            double d2 = Math.abs(unitConverter.convert(this.resolution));
            if (d2 < this.resolution) {
                this.resolution = d2;
                this.unit = unit;
            } else {
                d = Math.abs(unitConverter.inverse().convert(d));
            }
            if (d > this.magnitude) {
                this.magnitude = d;
            }
            return true;
        }

        void setPrecision(CoordinateFormat coordinateFormat) {
            Format format = coordinateFormat.getFormat(this.isAngular ? org.apache.sis.measure.Angle.class : Number.class);
            if (format instanceof NumberFormat) {
                if (this.resolution == 0.0) {
                    this.resolution = 1.0E-6;
                }
                int n = Math.max(0, DecimalFunctions.fractionDigitsForDelta(this.resolution, true));
                int n2 = Math.max(0, DecimalFunctions.fractionDigitsForDelta(Math.ulp(this.magnitude), false));
                ((NumberFormat)format).setMinimumFractionDigits(Math.min(n, n2));
                ((NumberFormat)format).setMaximumFractionDigits(n);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)format).setPrecision(this.resolution, true);
            }
        }
    }
}

