/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.WraparoundAdjustment;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridDerivation {
    protected final GridGeometry base;
    private GridRoundingMode rounding;
    private int[] margin;
    private GridExtent baseExtent;
    private GridExtent scaledExtent;
    private MathTransform toBase;
    private int[] modifiedDimensions;
    private double[] scales;
    private String subGridSetter;

    protected GridDerivation(GridGeometry gridGeometry) {
        ArgumentChecks.ensureNonNull("base", gridGeometry);
        this.base = gridGeometry;
        this.baseExtent = gridGeometry.extent;
        this.rounding = GridRoundingMode.NEAREST;
    }

    private void ensureSubgridNotSet() {
        if (this.subGridSetter != null) {
            throw new IllegalStateException(Resources.format((short)25, this.subGridSetter));
        }
    }

    public GridDerivation rounding(GridRoundingMode gridRoundingMode) {
        ArgumentChecks.ensureNonNull("mode", (Object)gridRoundingMode);
        this.ensureSubgridNotSet();
        this.rounding = gridRoundingMode;
        return this;
    }

    public GridDerivation margin(int ... nArray) {
        ArgumentChecks.ensureNonNull("cellCounts", nArray);
        this.ensureSubgridNotSet();
        int[] nArray2 = null;
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            ArgumentChecks.ensurePositive("cellCounts", n2);
            if (nArray2 == null) {
                nArray2 = new int[n + 1];
            }
            nArray2[n] = n2;
        }
        this.margin = nArray2;
        return this;
    }

    public GridDerivation resize(GridExtent gridExtent, double ... dArray) {
        int n;
        ArgumentChecks.ensureNonNull("scales", dArray);
        this.ensureSubgridNotSet();
        this.subGridSetter = "resize";
        int n2 = this.base.getDimension();
        if (gridExtent != null && (n = gridExtent.getDimension()) != n2) {
            throw new IllegalArgumentException(Errors.format((short)81, "extent", n2, n));
        }
        n = dArray.length;
        dArray = Arrays.copyOf(dArray, n2);
        if (n < n2) {
            Arrays.fill(dArray, n, n2, 1.0);
        }
        this.toBase = MathTransforms.scale(dArray);
        this.scales = dArray;
        if (gridExtent == null && this.baseExtent != null) {
            try {
                MathTransform mathTransform = this.toBase.inverse();
                GeneralEnvelope generalEnvelope = this.baseExtent.toCRS(mathTransform, mathTransform, null);
                gridExtent = new GridExtent(generalEnvelope, this.rounding, this.margin, null, null);
            }
            catch (TransformException transformException) {
                throw new IllegalArgumentException(transformException);
            }
        }
        this.scaledExtent = gridExtent;
        return this;
    }

    public GridDerivation subgrid(GridGeometry gridGeometry) {
        ArgumentChecks.ensureNonNull("gridOfInterest", gridGeometry);
        this.ensureSubgridNotSet();
        this.subGridSetter = "subgrid";
        if (!this.base.equals(gridGeometry)) {
            MathTransform mathTransform;
            GridExtent gridExtent = gridGeometry.getExtent();
            try {
                CoordinateOperation coordinateOperation = Envelopes.findOperation(gridGeometry.envelope, this.base.envelope);
                MathTransform mathTransform2 = GridDerivation.path(gridGeometry, coordinateOperation, this.base, PixelInCell.CELL_CORNER);
                mathTransform = GridDerivation.path(gridGeometry, coordinateOperation, this.base, PixelInCell.CELL_CENTER);
                this.clipExtent(gridExtent.toCRS(mathTransform2, mathTransform, null));
            }
            catch (TransformException | FactoryException exception) {
                throw new IllegalGridGeometryException(exception, "gridOfInterest");
            }
            if (this.baseExtent != this.base.extent && this.baseExtent.equals(gridGeometry.extent)) {
                this.baseExtent = gridGeometry.extent;
            }
            this.scales = GridGeometry.resolution(mathTransform, gridExtent);
            this.subsample(this.getSubsamplings());
        }
        return this;
    }

    private static MathTransform path(GridGeometry gridGeometry, CoordinateOperation coordinateOperation, GridGeometry gridGeometry2, PixelInCell pixelInCell) throws NoninvertibleTransformException {
        MathTransform mathTransform = gridGeometry.getGridToCRS(pixelInCell);
        MathTransform mathTransform2 = gridGeometry2.getGridToCRS(pixelInCell);
        if (coordinateOperation != null) {
            mathTransform = MathTransforms.concatenate(mathTransform, coordinateOperation.getMathTransform());
        }
        if (mathTransform.equals(mathTransform2)) {
            return MathTransforms.identity(mathTransform.getSourceDimensions());
        }
        return MathTransforms.concatenate(mathTransform, mathTransform2.inverse());
    }

    public GridDerivation subgrid(Envelope envelope, double ... dArray) {
        this.ensureSubgridNotSet();
        MathTransform mathTransform = this.base.requireGridToCRS(false);
        this.subGridSetter = "subgrid";
        try {
            Object object;
            CoordinateReferenceSystem coordinateReferenceSystem;
            MathTransform mathTransform2 = null;
            if (envelope != null && (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) != null) {
                object = Envelopes.findOperation(this.base.envelope, envelope);
                if (object == null) {
                    object = CRS.findOperation(this.base.getCoordinateReferenceSystem(), coordinateReferenceSystem, null);
                }
                mathTransform2 = object.getMathTransform();
                mathTransform = MathTransforms.concatenate(mathTransform, mathTransform2);
            }
            int n = mathTransform.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("areaOfInterest", n, envelope);
            mathTransform = this.dropUnusedDimensions(mathTransform, n);
            n = this.baseExtent.getDimension();
            object = null;
            if (envelope != null) {
                object = new WraparoundAdjustment(this.base.envelope, mathTransform2, mathTransform.inverse()).shift(envelope);
                this.clipExtent((GeneralEnvelope)object);
            }
            if (object == null || ((GeneralEnvelope)object).getDimension() != n) {
                object = new GeneralEnvelope(n);
            }
            for (int i = 0; i < n; ++i) {
                ((GeneralEnvelope)object).setRange(i, this.baseExtent.getLow(i), (double)this.baseExtent.getHigh(i) + 1.0);
            }
            if (dArray != null && dArray.length != 0) {
                int n2;
                double d;
                int n3;
                dArray = ArraysExt.resize(dArray, mathTransform.getTargetDimensions());
                Matrix matrix = mathTransform.derivative(new DirectPositionView.Double(this.getPointOfInterest()));
                double[] dArray2 = Matrices.inverse(matrix).multiply(dArray);
                int[] nArray = this.modifiedDimensions;
                boolean bl = false;
                for (n3 = 0; n3 < dArray2.length; ++n3) {
                    d = Math.abs(dArray2[n3]);
                    if (d > 1.0) {
                        n2 = nArray != null ? nArray[n3] : n3;
                        int n4 = Math.max(0, Math.getExponent(((GeneralEnvelope)object).getSpan(n2))) + 1;
                        d = Math.scalb(Math.rint(Math.scalb(d, n4)), -n4);
                        ((GeneralEnvelope)object).setRange(n2, ((GeneralEnvelope)object).getLower(n2) / d, ((GeneralEnvelope)object).getUpper(n2) / d);
                        bl = true;
                    }
                    dArray2[n3] = d;
                }
                if (bl) {
                    this.scaledExtent = new GridExtent((AbstractEnvelope)object, this.rounding, null, null, nArray);
                    if (this.baseExtent.equals(this.scaledExtent)) {
                        this.scaledExtent = this.baseExtent;
                    }
                    matrix = Matrices.createIdentity(n + 1);
                    for (n3 = 0; n3 < dArray2.length; ++n3) {
                        d = dArray2[n3];
                        if (!(d > 1.0)) continue;
                        n2 = nArray != null ? nArray[n3] : n3;
                        matrix.setElement(n2, n2, d);
                        matrix.setElement(n2, n, (double)this.baseExtent.getLow(n2) - (double)this.scaledExtent.getLow(n2) * d);
                    }
                    this.toBase = MathTransforms.linear(matrix);
                    this.scales = dArray2;
                }
            }
        }
        catch (TransformException | FactoryException exception) {
            throw new IllegalGridGeometryException(exception, "areaOfInterest");
        }
        this.modifiedDimensions = null;
        return this;
    }

    private MathTransform dropUnusedDimensions(MathTransform mathTransform, int n) throws FactoryException, TransformException {
        if (n < mathTransform.getSourceDimensions()) {
            TransformSeparator transformSeparator = new TransformSeparator(mathTransform);
            mathTransform = transformSeparator.separate();
            this.modifiedDimensions = transformSeparator.getSourceDimensions();
            if (this.modifiedDimensions.length != n) {
                throw new TransformException(Resources.format((short)24));
            }
        }
        return mathTransform;
    }

    private double[] getPointOfInterest() {
        double[] dArray = this.baseExtent.getPointOfInterest();
        if (this.modifiedDimensions == null) {
            return dArray;
        }
        double[] dArray2 = new double[this.modifiedDimensions.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[this.modifiedDimensions[i]];
        }
        return dArray2;
    }

    private void clipExtent(GeneralEnvelope generalEnvelope) {
        GridExtent gridExtent = new GridExtent(generalEnvelope, this.rounding, this.margin, this.baseExtent, this.modifiedDimensions);
        if (!gridExtent.equals(this.baseExtent)) {
            this.baseExtent = gridExtent;
        }
    }

    public GridDerivation subsample(int ... nArray) {
        ArgumentChecks.ensureNonNull("subsamplings", nArray);
        if (this.toBase != null) {
            throw new IllegalStateException(Errors.format((short)164, "subsamplings"));
        }
        GridExtent gridExtent = this.baseExtent != null ? this.baseExtent : this.base.getExtent();
        MatrixSIS matrixSIS = null;
        int n = gridExtent.getDimension();
        int n2 = Math.min(n, nArray.length);
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 == 1) continue;
            if (matrixSIS == null) {
                matrixSIS = Matrices.createIdentity(n + 1);
                this.scaledExtent = gridExtent.subsample(nArray);
            }
            double d = n3;
            matrixSIS.setElement(n2, n2, d);
            matrixSIS.setElement(n2, n, (double)gridExtent.getLow(n2) - (double)this.scaledExtent.getLow(n2) * d);
        }
        if (matrixSIS != null) {
            this.toBase = MathTransforms.linear(matrixSIS);
            if (this.scales == null) {
                this.scales = new double[n];
                for (n2 = 0; n2 < n; ++n2) {
                    this.scales[n2] = matrixSIS.getElement(n2, n2);
                }
            }
        }
        return this;
    }

    public GridDerivation slice(DirectPosition directPosition) {
        ArgumentChecks.ensureNonNull("slicePoint", directPosition);
        MathTransform mathTransform = this.base.requireGridToCRS(true);
        this.subGridSetter = "slice";
        try {
            MathTransform mathTransform2;
            CoordinateReferenceSystem coordinateReferenceSystem;
            if (this.toBase != null) {
                mathTransform = MathTransforms.concatenate(this.toBase, mathTransform);
            }
            if ((coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem()) == null) {
                mathTransform2 = null;
            } else {
                CoordinateReferenceSystem coordinateReferenceSystem2 = this.base.getCoordinateReferenceSystem();
                mathTransform2 = CRS.findOperation(coordinateReferenceSystem2, coordinateReferenceSystem, null).getMathTransform();
                mathTransform = MathTransforms.concatenate(mathTransform, mathTransform2);
            }
            int n = mathTransform.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("slicePoint", n, directPosition);
            mathTransform = this.dropUnusedDimensions(mathTransform, n);
            DirectPosition directPosition2 = new WraparoundAdjustment(this.base.envelope, mathTransform2, mathTransform.inverse()).shift(directPosition);
            if (this.scaledExtent != null) {
                this.scaledExtent = this.scaledExtent.slice(directPosition2, this.modifiedDimensions);
            }
            if (this.toBase != null) {
                directPosition2 = this.toBase.transform(directPosition2, directPosition2);
            }
            this.baseExtent = this.baseExtent.slice(directPosition2, this.modifiedDimensions);
        }
        catch (FactoryException factoryException) {
            throw new IllegalGridGeometryException(Resources.format((short)24), factoryException);
        }
        catch (TransformException transformException) {
            throw new IllegalGridGeometryException(transformException, "slicePoint");
        }
        this.modifiedDimensions = null;
        return this;
    }

    public GridDerivation sliceByRatio(double d, int ... nArray) {
        ArgumentChecks.ensureBetween("sliceRatio", 0.0, 1.0, d);
        ArgumentChecks.ensureNonNull("dimensionsToKeep", nArray);
        this.subGridSetter = "sliceByRatio";
        GridExtent gridExtent = this.baseExtent != null ? this.baseExtent : this.base.getExtent();
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(gridExtent.getDimension());
        this.baseExtent = gridExtent.sliceByRatio(generalDirectPosition, d, nArray);
        if (this.scaledExtent != null) {
            this.scaledExtent = this.scaledExtent.sliceByRatio(generalDirectPosition, d, nArray);
        }
        return this;
    }

    public GridGeometry build() {
        GridExtent gridExtent;
        GridExtent gridExtent2 = gridExtent = this.scaledExtent != null ? this.scaledExtent : this.baseExtent;
        if (this.toBase != null || gridExtent != this.base.extent) {
            try {
                return new GridGeometry(this.base, gridExtent, this.toBase);
            }
            catch (TransformException transformException) {
                throw new IllegalGridGeometryException(transformException, "envelope");
            }
        }
        return this.base;
    }

    public GridExtent getIntersection() {
        return this.baseExtent != null ? this.baseExtent : this.base.getExtent();
    }

    public int[] getSubsamplings() {
        int[] nArray;
        if (this.scales == null) {
            nArray = new int[this.getIntersection().getDimension()];
            Arrays.fill(nArray, 1);
        } else {
            nArray = new int[this.scales.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                switch (this.rounding) {
                    default: {
                        throw new AssertionError((Object)this.rounding);
                    }
                    case NEAREST: {
                        n = (int)Math.min(Math.round(this.scales[i]), Integer.MAX_VALUE);
                        break;
                    }
                    case ENCLOSING: {
                        n = (int)Math.nextUp(this.scales[i]);
                    }
                }
                nArray[i] = Math.max(1, n);
            }
        }
        return nArray;
    }

    public double getGlobalScale() {
        if (this.scales != null) {
            double d = 0.0;
            int n = 0;
            for (double d2 : this.scales) {
                if (!Double.isFinite(d2)) continue;
                d += d2;
                ++n;
            }
            if (n != 0) {
                return d / (double)n;
            }
        }
        return 1.0;
    }

    private TreeTable toTree(Locale locale) {
        Object object;
        TableColumn<CharSequence> tableColumn = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(tableColumn);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(tableColumn, Classes.getShortClassName(this));
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.baseExtent != null) {
            object = node.newChild();
            object.setValue(tableColumn, "Intersection");
            try {
                this.getIntersection().appendTo(stringBuilder, Vocabulary.getResources(locale));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            CharSequence[] charSequenceArray = CharSequences.splitOnEOL(stringBuilder);
            int n = charSequenceArray.length;
            for (Object object2 = 0; object2 < n; ++object2) {
                CharSequence charSequence = charSequenceArray[object2];
                String string = charSequence.toString().trim();
                if (string.isEmpty()) continue;
                object.newChild().setValue(tableColumn, string);
            }
        }
        if (this.scales != null) {
            stringBuilder.setLength(0);
            stringBuilder.append('{');
            for (Object object2 : (Object)this.getSubsamplings()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((int)object2);
            }
            object = node.newChild();
            object.setValue(tableColumn, "Subsamplings");
            object.newChild().setValue(tableColumn, stringBuilder.append('}').toString());
            stringBuilder.setLength(0);
            object.newChild().setValue(tableColumn, stringBuilder.append("Global \u2248 ").append((float)this.getGlobalScale()).toString());
        }
        return defaultTreeTable;
    }

    public String toString() {
        return this.toTree(null).toString();
    }
}

