/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.ConvertedCategory;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class CategoryList
extends AbstractList<Category>
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = -457688134719705403L;
    static final CategoryList EMPTY = new CategoryList();
    final NumberRange<?> range;
    private final double[] minimums;
    private final Category[] categories;
    private final double[] converseRanges;
    private transient int lastUsed;
    final CategoryList converse;

    private CategoryList() {
        this.range = null;
        this.minimums = ArraysExt.EMPTY_DOUBLE;
        this.categories = new Category[0];
        this.converseRanges = null;
        this.converse = this;
    }

    private CategoryList(Category[] categoryArray, CategoryList categoryList) {
        Category category;
        this.categories = categoryArray;
        int n = categoryArray.length;
        if (categoryList == null) {
            for (int i = 0; i < n; ++i) {
                Category category2 = categoryArray[i];
                if (!(category2 instanceof ConvertedCategory)) continue;
                categoryArray[i] = new Category(category2, null);
            }
        }
        Arrays.sort(categoryArray, Category.COMPARATOR);
        double[] dArray = new double[n << 1];
        this.minimums = new double[n];
        int n2 = 0;
        NumberRange<?> numberRange = null;
        int n3 = n;
        while (--n3 >= 0) {
            category = categoryArray[n3];
            this.minimums[n3] = category.range.getMinDouble(true);
            if (!Double.isNaN(this.minimums[n3])) {
                if (numberRange == null) {
                    numberRange = categoryArray[0].range;
                    assert (!Double.isNaN(numberRange.getMinDouble())) : numberRange;
                }
                numberRange = numberRange.unionAny(category.range);
            }
            int n4 = n3 << 1;
            NumberRange<?> numberRange2 = category.converse.range;
            double d = numberRange2.getMaxDouble(true);
            dArray[n4 | 1] = d;
            dArray[n4] = numberRange2.getMinDouble(true);
            if (!(!Double.isNaN(d) | !Double.isNaN(dArray[n4]))) continue;
            ++n2;
        }
        this.range = numberRange;
        Object object = this.converseRanges = (Object)(n2 > 1 ? dArray : null);
        assert (ArraysExt.isSorted(this.minimums, false));
        for (n3 = 1; n3 < n; ++n3) {
            category = categoryArray[n3];
            Category category3 = categoryArray[n3 - 1];
            double d = this.minimums[n3];
            if (Category.compare(d, category3.range.getMaxDouble(true)) <= 0) {
                throw new IllegalArgumentException(Resources.format((short)27, category3.name, category3.getRangeLabel(), category.name, category.getRangeLabel()));
            }
            double d2 = category3.range.getMaxDouble(false);
            if (!(d > d2) || !category3.converse.isConvertedQualitative() || category.converse.isConvertedQualitative()) continue;
            this.minimums[n3] = d2;
        }
        assert (ArraysExt.isSorted(this.minimums, true));
        if (categoryList == null) {
            int n5;
            n3 = 1;
            boolean bl = true;
            Category[] categoryArray2 = new Category[n];
            for (n5 = 0; n5 < n; ++n5) {
                Category category4;
                Category category5 = categoryArray[n5];
                categoryArray2[n5] = category4 = category5.converse;
                n3 &= category4.isConvertedQualitative();
                bl &= category5 == category4;
            }
            if (n3 != 0) {
                categoryList = EMPTY;
            } else if (bl) {
                categoryList = this;
            } else {
                categoryList = new CategoryList(categoryArray2, this);
                if (this.converseRanges != null) {
                    for (n5 = 1; n5 < this.converseRanges.length; n5 += 2) {
                        double d = this.converseRanges[n5];
                        int n6 = ~Arrays.binarySearch(categoryList.minimums, d);
                        if (n6 >= 0 && n6 < n) {
                            double d3 = Math.nextDown(categoryList.minimums[n6]);
                            if (Double.isNaN(d3)) {
                                d3 = Double.POSITIVE_INFINITY;
                            }
                            if (d3 > d) {
                                this.converseRanges[n5] = d3;
                            }
                            if (n6 != 1) continue;
                            this.converseRanges[n5 - 1] = Double.NEGATIVE_INFINITY;
                            continue;
                        }
                        if (n6 != n) continue;
                        this.converseRanges[n5] = Double.POSITIVE_INFINITY;
                    }
                }
            }
        }
        this.converse = categoryList;
        if (n != 0 && !Double.isNaN(this.minimums[0])) {
            this.minimums[0] = Double.NEGATIVE_INFINITY;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.categories.length == 0 ? EMPTY : this;
    }

    static CategoryList create(Category[] categoryArray) {
        return new CategoryList(categoryArray, null);
    }

    final MathTransform1D getTransferFunction() {
        MathTransform1D mathTransform1D = this.categories[0].toConverse;
        int n = this.categories.length;
        while (--n >= 1) {
            if (mathTransform1D.equals(this.categories[n].toConverse)) continue;
            mathTransform1D = this;
            break;
        }
        return mathTransform1D;
    }

    static int binarySearch(double[] dArray, double d) {
        int n = 0;
        int n2 = dArray.length - 1;
        boolean bl = Double.isNaN(d);
        while (n <= n2) {
            boolean bl2;
            long l;
            int n3 = n + n2 >>> 1;
            double d2 = dArray[n3];
            if (d2 < d) {
                n = n3 + 1;
                continue;
            }
            if (d2 > d) {
                n2 = n3 - 1;
                continue;
            }
            long l2 = Double.doubleToRawLongBits(d2);
            if (l2 == (l = Double.doubleToRawLongBits(d))) {
                return n3;
            }
            boolean bl3 = Double.isNaN(d2);
            if (bl) {
                bl2 = !bl3 || l2 < l;
            } else {
                boolean bl4 = bl2 = !bl3 && l2 < l;
            }
            if (bl2) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return bl ? -1 : n - 1;
    }

    final Category search(double d) {
        int n = CategoryList.binarySearch(this.minimums, d);
        return n >= 0 ? this.categories[n] : null;
    }

    private void transform(double[] dArray, float[] fArray, int n, double[] dArray2, float[] fArray2, int n2, int n3) throws TransformException {
        int n4;
        int n5 = n2 - n;
        if (n >= n2 || (fArray != null ? fArray != fArray2 : dArray != dArray2)) {
            n4 = 1;
        } else {
            n4 = -1;
            n += n3 - 1;
        }
        int n6 = this.lastUsed;
        double d = Double.NaN;
        int n7 = n;
        while (true) {
            int n8;
            double d2 = this.minimums[n6];
            double d3 = n6 + 1 < this.minimums.length ? this.minimums[n6 + 1] : Double.NaN;
            long l = Double.doubleToRawLongBits(d2);
            while (--n3 >= 0) {
                double d4 = d = fArray != null ? (double)fArray[n7] : dArray[n7];
                if (d >= d2 ? d >= d3 : Double.doubleToRawLongBits(d) != l) break;
                n7 += n4;
            }
            if ((n8 = n7 - n) < 0) {
                n8 = -n8;
                n -= n8 - 1;
            }
            int n9 = n + n5;
            MathTransform1D mathTransform1D = this.categories[n6].toConverse;
            if (fArray != null) {
                if (fArray2 != null) {
                    mathTransform1D.transform(fArray, n, fArray2, n9, n8);
                } else {
                    mathTransform1D.transform(fArray, n, dArray2, n9, n8);
                }
            } else if (fArray2 != null) {
                mathTransform1D.transform(dArray, n, fArray2, n9, n8);
            } else {
                mathTransform1D.transform(dArray, n, dArray2, n9, n8);
            }
            if (this.converseRanges != null) {
                n2 = n + n5;
                if (fArray2 != null) {
                    float f = (float)this.converseRanges[n6 << 1];
                    float f2 = (float)this.converseRanges[n6 << 1 | 1];
                    while (--n8 >= 0) {
                        float f3 = fArray2[n2];
                        if (f3 < f) {
                            fArray2[n2] = f;
                        } else if (f3 > f2) {
                            fArray2[n2] = f2;
                        }
                        ++n2;
                    }
                } else {
                    double d5 = this.converseRanges[n6 << 1];
                    double d6 = this.converseRanges[n6 << 1 | 1];
                    while (--n8 >= 0) {
                        double d7 = dArray2[n2];
                        if (d7 < d5) {
                            dArray2[n2] = d5;
                        } else if (d7 > d6) {
                            dArray2[n2] = d6;
                        }
                        ++n2;
                    }
                }
            }
            if (n3 < 0) break;
            n6 = CategoryList.binarySearch(this.minimums, d);
            if (n6 < 0) {
                throw new TransformException(Resources.format((short)43, d));
            }
            n = n7;
            n7 += n4;
        }
        this.lastUsed = n6;
    }

    @Override
    public final void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transform(dArray, null, n, dArray2, null, n2, n3);
    }

    @Override
    public final void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transform(null, fArray, n, null, fArray2, n2, n3);
    }

    @Override
    public final void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        this.transform(null, fArray, n, dArray, null, n2, n3);
    }

    @Override
    public final void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        this.transform(dArray, null, n, null, fArray, n2, n3);
    }

    @Override
    public final double transform(double d) throws TransformException {
        int n = this.lastUsed;
        double d2 = this.minimums[n];
        if (d >= d2 ? n + 1 < this.minimums.length && d >= this.minimums[n + 1] : Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(d2)) {
            n = CategoryList.binarySearch(this.minimums, d);
            if (n < 0) {
                throw new TransformException(Resources.format((short)43, d));
            }
            this.lastUsed = n;
        }
        d = this.categories[n].toConverse.transform(d);
        if (this.converseRanges != null) {
            double d3;
            double d4;
            double d5 = this.converseRanges[n << 1];
            if (d < d4) {
                return d5;
            }
            d5 = this.converseRanges[n << 1 | 1];
            if (d > d3) {
                return d5;
            }
        }
        return d;
    }

    @Override
    public final double derivative(double d) throws TransformException {
        int n = this.lastUsed;
        double d2 = this.minimums[n];
        if (d >= d2 ? n + 1 < this.minimums.length && d >= this.minimums[n + 1] : Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(d2)) {
            n = CategoryList.binarySearch(this.minimums, d);
            if (n < 0) {
                throw new TransformException(Resources.format((short)43, d));
            }
            this.lastUsed = n;
        }
        return this.categories[n].toConverse.derivative(d);
    }

    @Override
    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        ArgumentChecks.ensureNonNull("ptSrc", directPosition);
        ArgumentChecks.ensureDimensionMatches("ptSrc", 1, directPosition);
        if (directPosition2 == null) {
            directPosition2 = new GeneralDirectPosition(1);
        } else {
            ArgumentChecks.ensureDimensionMatches("ptDst", 1, directPosition2);
        }
        directPosition2.setOrdinate(0, this.transform(directPosition.getOrdinate(0)));
        return directPosition2;
    }

    @Override
    public final Matrix derivative(DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("point", directPosition);
        ArgumentChecks.ensureDimensionMatches("point", 1, directPosition);
        return new Matrix1(this.derivative(directPosition.getOrdinate(0)));
    }

    @Override
    public boolean isIdentity() {
        return this.converse == this;
    }

    @Override
    public final MathTransform1D inverse() {
        return this.converse;
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    public final int size() {
        return this.categories.length;
    }

    @Override
    public final Category get(int n) {
        return this.categories[n];
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList categoryList = (CategoryList)object;
            if (Arrays.equals(this.categories, categoryList.categories)) {
                assert (Arrays.equals(this.minimums, categoryList.minimums));
            } else {
                return false;
            }
        }
        return super.equals(object);
    }

    @Override
    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.");
    }
}

