/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LangModel {
    public static LangModel EMPTY_MODEL = new LangModel(-1L);
    private final long totalTokens;
    private final double unseenPercentage;
    private Map<String, Double> percentages = new HashMap<String, Double>();
    private Map<String, Long> counts = new HashMap<String, Long>();

    public LangModel(long totalTokens) {
        this.totalTokens = totalTokens;
        this.unseenPercentage = 1.0 / (double)totalTokens;
    }

    public boolean contains(String token) {
        return this.percentages.containsKey(token);
    }

    public Set<String> getTokens() {
        return this.percentages.keySet();
    }

    public double getProbability(String token) {
        Double p = this.percentages.get(token);
        if (p != null) {
            return p;
        }
        return this.unseenPercentage;
    }

    public void add(String t, long tf) {
        double p = (double)tf / (double)this.totalTokens;
        this.percentages.put(t, p);
        this.counts.put(t, tf);
    }

    public double getUnseenProbability() {
        return this.unseenPercentage;
    }

    public long getCount(String token) {
        Long cnt = this.counts.get(token);
        if (cnt == null) {
            return 0L;
        }
        return cnt;
    }

    public Map<String, Long> getCounts() {
        return this.counts;
    }
}

