/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.tika.eval.tokens.AnalyzerDeserializer;

public class AnalyzerManager {
    private static final String GENERAL = "general";
    private static final String ALPHA_IDEOGRAPH = "alpha";
    private static final String COMMON_TOKENS = "common_tokens";
    private final Analyzer generalAnalyzer;
    private final Analyzer commonTokensAnalyzer;

    private AnalyzerManager(Analyzer generalAnalyzer, Analyzer commonTokensAnalyzer) {
        this.generalAnalyzer = generalAnalyzer;
        this.commonTokensAnalyzer = commonTokensAnalyzer;
    }

    public static AnalyzerManager newInstance(int maxTokens) {
        InputStream is = AnalyzerManager.class.getClassLoader().getResourceAsStream("lucene-analyzers.json");
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Map.class, new AnalyzerDeserializer(maxTokens));
        Gson gson = builder.create();
        Map map = gson.fromJson((Reader)reader, Map.class);
        Analyzer general = (Analyzer)map.get(GENERAL);
        Analyzer alphaIdeo = (Analyzer)map.get(ALPHA_IDEOGRAPH);
        Analyzer common = (Analyzer)map.get(COMMON_TOKENS);
        if (general == null) {
            throw new JsonParseException("Must specify general analyzer");
        }
        if (common == null) {
            throw new JsonParseException("Must specify common_tokens analyzer");
        }
        return new AnalyzerManager(general, common);
    }

    public Analyzer getGeneralAnalyzer() {
        return this.generalAnalyzer;
    }

    public Analyzer getCommonTokensAnalyzer() {
        return this.commonTokensAnalyzer;
    }
}

