/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class AlphaIdeographFilterFactory
extends TokenFilterFactory {
    private static final int UNDERSCORE = 95;

    public AlphaIdeographFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new AlphaFilter(tokenStream);
    }

    public static boolean isAlphabetic(char[] token, int length) {
        for (int i = 0; i < length; ++i) {
            int cp = token[i];
            if (Character.isHighSurrogate(token[i]) && i < length - 1) {
                cp = Character.toCodePoint(token[i], token[i + 1]);
                ++i;
            }
            if (Character.isDigit(cp)) {
                return false;
            }
            if (Character.isAlphabetic(cp) || Character.isIdeographic(cp) || cp == 95) continue;
            return false;
        }
        return true;
    }

    private class AlphaFilter
    extends FilteringTokenFilter {
        private final CharTermAttribute termAtt;
        private final TypeAttribute typeAtt;

        public AlphaFilter(TokenStream in) {
            super(in);
            this.termAtt = this.addAttribute(CharTermAttribute.class);
            this.typeAtt = this.addAttribute(TypeAttribute.class);
        }

        @Override
        protected boolean accept() throws IOException {
            String type = this.typeAtt.type();
            if (type == UAX29URLEmailTokenizer.TOKEN_TYPES[9] || type == UAX29URLEmailTokenizer.TOKEN_TYPES[1]) {
                return false;
            }
            return AlphaIdeographFilterFactory.isAlphabetic(this.termAtt.buffer(), this.termAtt.length());
        }
    }
}

