/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.textstats;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.eval.langid.Language;
import org.apache.tika.eval.textstats.LanguageAwareTokenCountStats;
import org.apache.tika.eval.tokens.AlphaIdeographFilterFactory;
import org.apache.tika.eval.tokens.CommonTokenCountManager;
import org.apache.tika.eval.tokens.CommonTokenResult;
import org.apache.tika.eval.tokens.LangModel;
import org.apache.tika.eval.tokens.TokenCounts;

public class CommonTokens
implements LanguageAwareTokenCountStats<CommonTokenResult> {
    private final CommonTokenCountManager commonTokenCountManager;

    public CommonTokens() {
        this(new CommonTokenCountManager());
    }

    public CommonTokens(CommonTokenCountManager mgr) {
        this.commonTokenCountManager = mgr;
    }

    @Override
    public CommonTokenResult calculate(List<Language> languages, TokenCounts tokenCounts) {
        Pair<String, LangModel> pair = this.commonTokenCountManager.getLangTokens(languages.get(0).getLanguage());
        String actualLangCode = pair.getKey();
        Set<String> commonTokens = pair.getValue().getTokens();
        int numUniqueCommonTokens = 0;
        int numCommonTokens = 0;
        int numUniqueAlphabeticTokens = 0;
        int numAlphabeticTokens = 0;
        for (Map.Entry<String, MutableInt> e : tokenCounts.getTokens().entrySet()) {
            String token = e.getKey();
            int count = e.getValue().intValue();
            if (AlphaIdeographFilterFactory.isAlphabetic(token.toCharArray(), token.length())) {
                numAlphabeticTokens += count;
                ++numUniqueAlphabeticTokens;
            }
            if (!commonTokens.contains(token)) continue;
            numCommonTokens += count;
            ++numUniqueCommonTokens;
        }
        return new CommonTokenResult(actualLangCode, numUniqueCommonTokens, numCommonTokens, numUniqueAlphabeticTokens, numAlphabeticTokens);
    }
}

