/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.reports;

import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tika.eval.reports.XSLXCellFormatter;

public class XLSXHREFFormatter
implements XSLXCellFormatter {
    private static final int MAX_HYPERLINKS = 65000;
    private final String urlBase;
    private final HyperlinkType linkType;
    private XSSFWorkbook workbook;
    private CellStyle style;
    private int links = 0;

    public XLSXHREFFormatter(String urlBase, HyperlinkType hyperlinkType) {
        this.urlBase = urlBase;
        this.linkType = hyperlinkType;
    }

    @Override
    public void reset(XSSFWorkbook workbook) {
        this.workbook = workbook;
        this.style = workbook.createCellStyle();
        XSSFFont hlinkFont = workbook.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        this.style.setFont(hlinkFont);
        this.links = 0;
    }

    @Override
    public void applyStyleAndValue(int dbColNum, ResultSet resultSet, Cell cell) throws SQLException {
        if (this.links < 65000) {
            XSSFHyperlink hyperlink = this.workbook.getCreationHelper().createHyperlink(this.linkType);
            String path = resultSet.getString(dbColNum);
            String address = this.urlBase + path;
            hyperlink.setAddress(address);
            cell.setHyperlink(hyperlink);
            cell.setCellStyle(this.style);
            String fName = Paths.get(path, new String[0]).getFileName().toString();
            cell.setCellValue(fName);
            ++this.links;
        }
    }
}

