/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.langid;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.util.normalizer.AggregateCharSequenceNormalizer;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;
import org.apache.commons.lang3.mutable.MutableInt;

class ProbingLanguageDetector
implements LanguageDetector {
    public static final int DEFAULT_CHUNK_SIZE = 300;
    public static final int DEFAULT_MIN_CONSEC_IMPROVEMENTS = 2;
    public static final double DEFAULT_MIN_DIFF = 0.2;
    public static final int DEFAULT_MAX_LENGTH = 10000;
    private static final String SPACE = " ";
    private int chunkSize = 300;
    private int minConsecImprovements = 2;
    private double minDiff = 0.2;
    private int maxLength = 10000;
    private CharSequenceNormalizer normalizer;
    private LanguageDetectorModel model;

    public ProbingLanguageDetector(LanguageDetectorModel model, CharSequenceNormalizer ... normalizers) {
        this.model = model;
        this.normalizer = new AggregateCharSequenceNormalizer(normalizers);
    }

    @Override
    public Language predictLanguage(CharSequence content) {
        return this.predictLanguages(content)[0];
    }

    @Override
    public Language[] predictLanguages(CharSequence content) {
        LinkedList<Language[]> predictions = new LinkedList<Language[]>();
        int start = 0;
        Language[] currPredictions = null;
        HashMap<String, MutableInt> ngramCounts = new HashMap<String, MutableInt>();
        CharIntNGrammer ngrammer = new CharIntNGrammer(1, 3);
        int nGrams = 0;
        block0: while (true) {
            int actualChunkSize = start + this.chunkSize > this.maxLength ? this.maxLength - start : this.chunkSize;
            CSAndLength csAndLength = this.chunk(content, start, actualChunkSize);
            int[] chunk = csAndLength.normed.codePoints().toArray();
            if (csAndLength.originalLength == 0) {
                if (currPredictions == null) {
                    return this.predict(ngramCounts);
                }
                return currPredictions;
            }
            start += csAndLength.originalLength;
            ngrammer.reset(chunk);
            while (true) {
                if (!ngrammer.hasNext()) continue block0;
                String nGram = ngrammer.next();
                if (nGram.equals(SPACE)) continue;
                MutableInt cnt = (MutableInt)ngramCounts.get(nGram);
                if (cnt == null) {
                    ngramCounts.put(nGram, new MutableInt(1));
                } else {
                    cnt.increment();
                }
                if (++nGrams % 110 == 0 && this.seenEnough(predictions, currPredictions = this.predict(ngramCounts), ngramCounts)) break block0;
            }
            break;
        }
        return currPredictions;
    }

    private Language[] predict(Map<String, MutableInt> ngramCounts) {
        String[] allGrams = new String[ngramCounts.size()];
        float[] counts = new float[ngramCounts.size()];
        int i = 0;
        for (Map.Entry<String, MutableInt> e : ngramCounts.entrySet()) {
            allGrams[i] = e.getKey();
            counts[i] = 1.0f;
            ++i;
        }
        double[] eval = this.model.getMaxentModel().eval(allGrams, counts);
        Language[] arr = new Language[eval.length];
        for (int j = 0; j < eval.length; ++j) {
            arr[j] = new Language(this.model.getMaxentModel().getOutcome(j), eval[j]);
        }
        Arrays.sort(arr, (o1, o2) -> Double.compare(o2.getConfidence(), o1.getConfidence()));
        return arr;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getMinConsecImprovements() {
        return this.minConsecImprovements;
    }

    public void setMinConsecImprovements(int minConsecImprovements) {
        this.minConsecImprovements = minConsecImprovements;
    }

    public double getMinDiff() {
        return this.minDiff;
    }

    public void setMinDiff(double minDiff) {
        if (minDiff < 0.0) {
            throw new IllegalArgumentException("minDiff must be >= 0.0");
        }
        this.minDiff = minDiff;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setNormalizer(CharSequenceNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    public String[] getSupportedLanguages() {
        int numberLanguages = this.model.getMaxentModel().getNumOutcomes();
        String[] languages = new String[numberLanguages];
        for (int i = 0; i < numberLanguages; ++i) {
            languages[i] = this.model.getMaxentModel().getOutcome(i);
        }
        return languages;
    }

    boolean seenEnough(LinkedList<Language[]> predictionsQueue, Language[] newPredictions, Map<String, MutableInt> ngramCounts) {
        if (predictionsQueue.size() < this.minConsecImprovements) {
            predictionsQueue.add(newPredictions);
            return false;
        }
        if (predictionsQueue.size() > this.minConsecImprovements) {
            predictionsQueue.removeFirst();
        }
        predictionsQueue.add(newPredictions);
        if (this.minDiff > 0.0 && newPredictions[0].getConfidence() - newPredictions[1].getConfidence() < this.minDiff) {
            return false;
        }
        String lastLang = null;
        double lastConf = -1.0;
        for (Language[] predictions : predictionsQueue) {
            if (lastLang == null) {
                lastLang = predictions[0].getLang();
                lastConf = predictions[0].getConfidence();
                continue;
            }
            if (!lastLang.equals(predictions[0].getLang())) {
                return false;
            }
            if (lastConf > predictions[0].getConfidence()) {
                return false;
            }
            lastLang = predictions[0].getLang();
            lastConf = predictions[0].getConfidence();
        }
        return true;
    }

    private CSAndLength chunk(CharSequence content, int start, int chunkSize) {
        if (start == 0 && chunkSize > content.length()) {
            int length = content.codePoints().toArray().length;
            return new CSAndLength(this.normalizer.normalize(content), length);
        }
        int[] codepoints = content.codePoints().skip(start).limit(chunkSize).toArray();
        String chunk = new String(codepoints, 0, codepoints.length);
        return new CSAndLength(this.normalizer.normalize(chunk), codepoints.length);
    }

    private static class CharIntNGrammer
    implements Iterator<String> {
        private String next;
        private int pos = 0;
        private int[] buffer;
        private final int minGram;
        private final int maxGram;
        private int currGram;

        CharIntNGrammer(int minGram, int maxGram) {
            this.minGram = minGram;
            this.maxGram = maxGram;
            this.currGram = minGram;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String ret = this.next;
            ++this.currGram;
            if (this.currGram > this.maxGram) {
                this.currGram = this.minGram;
                ++this.pos;
                if (this.pos + this.maxGram < this.buffer.length) {
                    this.buffer[this.pos + this.maxGram] = Character.toLowerCase(this.buffer[this.pos + this.maxGram]);
                }
            }
            if (this.pos + this.currGram > this.buffer.length) {
                this.currGram = this.minGram;
                ++this.pos;
            }
            if (this.pos >= this.buffer.length - 1) {
                this.next = null;
                return ret;
            }
            this.next = new String(this.buffer, this.pos, this.currGram);
            return ret;
        }

        void reset(int[] chunk) {
            this.next = null;
            this.pos = 0;
            this.currGram = this.minGram;
            this.buffer = chunk;
            if (this.buffer.length < this.minGram) {
                return;
            }
            int end = Math.min(this.buffer.length, this.maxGram);
            for (int i = 0; i < end; ++i) {
                this.buffer[i] = Character.toLowerCase(this.buffer[i]);
            }
            if (this.buffer.length >= this.minGram) {
                this.next = new String(this.buffer, 0, this.minGram);
            }
        }
    }

    private static class CSAndLength {
        private final CharSequence normed;
        private final int originalLength;

        public CSAndLength(CharSequence normed, int originalLength) {
            this.normed = normed;
            this.originalLength = originalLength;
        }
    }
}

