/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.batch;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.eval.ExtractProfiler;
import org.apache.tika.eval.FileProfiler;
import org.apache.tika.eval.batch.DBConsumersManager;
import org.apache.tika.eval.batch.EvalConsumerBuilder;
import org.apache.tika.eval.db.TableInfo;
import org.apache.tika.util.PropsUtil;

public class FileProfilerBuilder
extends EvalConsumerBuilder {
    public static final String TABLE_PREFIX_KEY = "tablePrefix";
    private final List<TableInfo> tableInfos;

    public FileProfilerBuilder() {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        tableInfos.add(FileProfiler.FILE_MIME_TABLE);
        tableInfos.add(FileProfiler.FILE_PROFILES);
        this.tableInfos = Collections.unmodifiableList(tableInfos);
    }

    @Override
    public FileResourceConsumer build() throws IOException, SQLException {
        Path inputDir = PropsUtil.getPath((String)this.localAttrs.get("inputDir"), null);
        if (inputDir == null) {
            throw new RuntimeException("Must specify -inputDir");
        }
        return this.parameterizeProfiler(new FileProfiler(this.queue, inputDir, this.getDBWriter(this.tableInfos)));
    }

    @Override
    protected void updateTableInfosWithPrefixes(Map<String, String> attrs) {
        String tableNamePrefix = attrs.get(TABLE_PREFIX_KEY);
        if (tableNamePrefix != null && !tableNamePrefix.equals("null")) {
            for (TableInfo tableInfo : this.tableInfos) {
                tableInfo.setNamePrefix(tableNamePrefix);
            }
        }
    }

    @Override
    protected List<TableInfo> getRefTableInfos() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected List<TableInfo> getNonRefTableInfos() {
        return this.tableInfos;
    }

    @Override
    protected TableInfo getMimeTable() {
        return FileProfiler.FILE_MIME_TABLE;
    }

    @Override
    protected void addErrorLogTablePairs(DBConsumersManager manager) {
        Path errorLog = PropsUtil.getPath((String)this.localAttrs.get("errorLogFile"), null);
        if (errorLog == null) {
            return;
        }
        manager.addErrorLogTablePair(errorLog, ExtractProfiler.EXTRACT_EXCEPTION_TABLE);
    }
}

