/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.batch;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.eval.AbstractProfiler;
import org.apache.tika.eval.XMLErrorLogUpdater;
import org.apache.tika.eval.db.JDBCUtil;
import org.apache.tika.eval.db.MimeBuffer;
import org.apache.tika.eval.db.TableInfo;

public class DBConsumersManager
extends ConsumersManager {
    private final Connection conn;
    private final MimeBuffer mimeBuffer;
    private final List<LogTablePair> errorLogs = new ArrayList<LogTablePair>();

    public DBConsumersManager(JDBCUtil dbUtil, MimeBuffer mimeBuffer, List<FileResourceConsumer> consumers) throws SQLException {
        super(consumers);
        this.conn = dbUtil.getConnection();
        this.mimeBuffer = mimeBuffer;
    }

    @Override
    public void shutdown() {
        for (FileResourceConsumer fileResourceConsumer : this.getConsumers()) {
            if (!(fileResourceConsumer instanceof AbstractProfiler)) continue;
            try {
                ((AbstractProfiler)fileResourceConsumer).closeWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.mimeBuffer.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        XMLErrorLogUpdater up = new XMLErrorLogUpdater();
        for (LogTablePair p : this.errorLogs) {
            try {
                up.update(this.conn, p.tableInfo, p.log);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public void addErrorLogTablePair(Path log, TableInfo tableInfo) {
        LogTablePair p = new LogTablePair();
        p.log = log;
        p.tableInfo = tableInfo;
        this.errorLogs.add(p);
    }

    class LogTablePair {
        Path log;
        TableInfo tableInfo;

        LogTablePair() {
        }
    }
}

