/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.textstats;

import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.tika.eval.textstats.TokenCountPriorityQueue;
import org.apache.tika.eval.textstats.TokenCountStatsCalculator;
import org.apache.tika.eval.tokens.TokenCounts;
import org.apache.tika.eval.tokens.TokenIntPair;

public class TopNTokens
implements TokenCountStatsCalculator<TokenIntPair[]> {
    private final int topN;

    public TopNTokens(int topN) {
        this.topN = topN;
    }

    @Override
    public TokenIntPair[] calculate(TokenCounts tokenCounts) {
        TokenCountPriorityQueue queue = new TokenCountPriorityQueue(this.topN);
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        for (Map.Entry<String, MutableInt> e : tokenCounts.getTokens().entrySet()) {
            String token = e.getKey();
            int termFreq = e.getValue().intValue();
            if (queue.top() != null && queue.size() >= this.topN && (long)termFreq < ((TokenIntPair)queue.top()).getValue()) continue;
            queue.insertWithOverflow(new TokenIntPair(token, termFreq));
        }
        return queue.getArray();
    }
}

