/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.textstats;

import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.eval.textstats.BytesRefCalculator;

public class TextSha256Signature
implements BytesRefCalculator<String> {
    static Base32 BASE32 = new Base32();

    @Override
    public BytesRefCalculator.BytesRefCalcInstance<String> getInstance() {
        return new TextSha256Instance();
    }

    class TextSha256Instance
    implements BytesRefCalculator.BytesRefCalcInstance<String> {
        private MessageDigest messageDigest = DigestUtils.getSha256Digest();

        TextSha256Instance() {
        }

        @Override
        public void update(byte[] bytes, int start, int len) {
            this.messageDigest.update(bytes, start, len);
        }

        @Override
        public String finish() {
            return BASE32.encodeAsString(this.messageDigest.digest());
        }

        @Override
        public Class getOuterClass() {
            return TextSha256Signature.class;
        }
    }
}

