/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.db;

import org.apache.tika.eval.db.Cols;

public class ColInfo {
    private final Cols name;
    private final int type;
    private final Integer precision;
    private final String constraints;

    public ColInfo(Cols name, int type) {
        this(name, type, null, null);
    }

    public ColInfo(Cols name, int type, String constraints) {
        this(name, type, null, constraints);
    }

    public ColInfo(Cols name, int type, Integer precision) {
        this(name, type, precision, null);
    }

    public ColInfo(Cols name, int type, Integer precision, String constraints) {
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.constraints = constraints;
    }

    public int getType() {
        return this.type;
    }

    public Cols getName() {
        return this.name;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public String getSqlDef() {
        if (this.type == 12) {
            return "VARCHAR(" + this.precision + ")";
        }
        if (this.type == 1) {
            return "CHAR(" + this.precision + ")";
        }
        switch (this.type) {
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2004: {
                return "BLOB";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        throw new UnsupportedOperationException("Don't yet recognize a type for: " + this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColInfo colInfo = (ColInfo)o;
        if (this.type != colInfo.type) {
            return false;
        }
        if (this.name != colInfo.name) {
            return false;
        }
        if (this.precision != null ? !this.precision.equals(colInfo.precision) : colInfo.precision != null) {
            return false;
        }
        return !(this.constraints == null ? colInfo.constraints != null : !this.constraints.equals(colInfo.constraints));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.type;
        result = 31 * result + (this.precision != null ? this.precision.hashCode() : 0);
        result = 31 * result + (this.constraints != null ? this.constraints.hashCode() : 0);
        return result;
    }
}

