/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;

public class RecursiveParserWrapperFSConsumer
extends AbstractFSConsumer {
    private final Parser parser;
    private final ContentHandlerFactory contentHandlerFactory;
    private final OutputStreamFactory fsOSFactory;
    private final MetadataFilter metadataFilter;
    private String outputEncoding = "UTF-8";

    public RecursiveParserWrapperFSConsumer(ArrayBlockingQueue<FileResource> queue, Parser parser, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory, MetadataFilter metadataFilter) {
        super(queue);
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
        this.parser = parser;
        this.metadataFilter = metadataFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFileResource(FileResource fileResource) {
        ParseContext context = new ParseContext();
        OutputStream os = this.getOutputStream(this.fsOSFactory, fileResource);
        if (os == null) {
            LOG.debug("Skipping: {}", (Object)fileResource.getMetadata().get(FSProperties.FS_REL_PATH));
            return false;
        }
        InputStream is = this.getInputStream(fileResource);
        if (is == null) {
            IOUtils.closeQuietly(os);
            return false;
        }
        Throwable thrown = null;
        List<Metadata> metadataList = null;
        Metadata containerMetadata = fileResource.getMetadata();
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler(this.contentHandlerFactory, -1, -1, this.metadataFilter);
        try {
            this.parse(fileResource.getResourceId(), this.parser, is, handler, containerMetadata, context);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            metadataList = handler.getMetadataList();
            IOUtils.closeQuietly(is);
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(os, this.getOutputEncoding());
            JsonMetadataList.toJson(metadataList, writer);
        }
        catch (Exception e) {
            try {
                LOG.error("{}", (Object)this.getXMLifiedLogMsg(IO_OS + "json", fileResource.getResourceId(), e, new String[0]));
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.flushAndClose(writer);
                throw throwable;
            }
        }
        this.flushAndClose(writer);
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof SecurityException) {
                throw (SecurityException)thrown;
            }
            return false;
        }
        return true;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

