/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLDOMUtil {
    public static Map<String, String> mapifyAttrs(Node node, Map<String, String> overwrite) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap nnMap = node.getAttributes();
        for (int i = 0; i < nnMap.getLength(); ++i) {
            Node attr = nnMap.item(i);
            map.put(attr.getNodeName(), attr.getNodeValue());
        }
        if (overwrite != null) {
            for (Map.Entry<String, String> e : overwrite.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
        }
        return map;
    }

    public static int getInt(String attrName, Map<String, String> runtimeAttributes, Node docElement) {
        String stringValue = XMLDOMUtil.getStringValue(attrName, runtimeAttributes, docElement);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Need to specify a parseable int value in -- " + attrName + " -- in commandline or in config file!");
    }

    public static long getLong(String attrName, Map<String, String> runtimeAttributes, Node docElement) {
        String stringValue = XMLDOMUtil.getStringValue(attrName, runtimeAttributes, docElement);
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Need to specify a \"long\" value in -- " + attrName + " -- in commandline or in config file!");
    }

    private static String getStringValue(String attrName, Map<String, String> runtimeAttributes, Node docElement) {
        Node staleNode;
        String stringValue = runtimeAttributes.get(attrName);
        if (stringValue == null && (staleNode = docElement.getAttributes().getNamedItem(attrName)) != null) {
            stringValue = staleNode.getNodeValue();
        }
        return stringValue;
    }
}

