/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tools;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.tika.eval.tools.LeipzigHelper;
import org.apache.tika.eval.tools.TopCommonTokenCounter;
import org.apache.tika.utils.ProcessUtils;

public class BatchTopCommonTokenCounter {
    public static void main(String[] args) throws Exception {
        Path commonTokensDir = Paths.get(args[0], new String[0]);
        Path tableFileDir = Paths.get(args[1], new String[0]);
        Map<String, List<Path>> langFiles = LeipzigHelper.getFiles(tableFileDir);
        for (Map.Entry<String, List<Path>> e : langFiles.entrySet()) {
            String[] cmd = new String[e.getValue().size() + 1];
            Path commonTokensFile = commonTokensDir.resolve(e.getKey());
            cmd[0] = ProcessUtils.escapeCommandLine(commonTokensFile.toAbsolutePath().toString());
            for (int i = 0; i < e.getValue().size(); ++i) {
                cmd[i + 1] = ProcessUtils.escapeCommandLine(e.getValue().get(i).toAbsolutePath().toString());
            }
            TopCommonTokenCounter.main(cmd);
        }
    }
}

