/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class CJKBigramAwareLengthFilterFactory
extends TokenFilterFactory {
    private final int min;
    private final int max;

    public CJKBigramAwareLengthFilterFactory(Map<String, String> args) {
        super(args);
        this.min = Integer.parseInt(args.get("min"));
        this.max = Integer.parseInt(args.get("max"));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new CJKAwareLengthFilter(tokenStream);
    }

    private class CJKAwareLengthFilter
    extends FilteringTokenFilter {
        private final CharTermAttribute termAtt;
        private final TypeAttribute typeAtt;

        public CJKAwareLengthFilter(TokenStream in) {
            super(in);
            this.termAtt = this.addAttribute(CharTermAttribute.class);
            this.typeAtt = this.addAttribute(TypeAttribute.class);
        }

        @Override
        protected boolean accept() throws IOException {
            String type;
            if (this.termAtt.length() < CJKBigramAwareLengthFilterFactory.this.min && ((type = this.typeAtt.type()) == "<DOUBLE>" || type == "<SINGLE>")) {
                return true;
            }
            return this.termAtt.length() >= CJKBigramAwareLengthFilterFactory.this.min && this.termAtt.length() <= CJKBigramAwareLengthFilterFactory.this.max;
        }
    }
}

