/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Level;
import org.apache.tika.eval.io.XMLLogMsgHandler;
import org.apache.tika.io.IOUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLLogReader {
    private static final Logger LOG = LoggerFactory.getLogger(XMLLogReader.class);

    public void read(InputStream xmlLogFileIs, XMLLogMsgHandler handler) throws XMLStreamException {
        LogXMLWrappingInputStream is = new LogXMLWrappingInputStream(xmlLogFileIs);
        XMLInputFactory factory = XMLReaderUtils.getXMLInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(is);
        Level level = null;
        while (reader.hasNext()) {
            reader.next();
            switch (reader.getEventType()) {
                case 1: {
                    if ("event".equals(reader.getLocalName())) {
                        level = Level.toLevel(reader.getAttributeValue("", "level"), Level.DEBUG);
                        break;
                    }
                    if (!"message".equals(reader.getLocalName())) break;
                    try {
                        handler.handleMsg(level, reader.getElementText());
                    }
                    catch (IOException e) {
                        LOG.warn("Error parsing: {}", (Object)reader.getElementText());
                    }
                    catch (SQLException e) {
                        LOG.warn("SQLException: {}", (Object)e.getMessage());
                    }
                    break;
                }
                case 2: {
                    if ("event".equals(reader.getLocalName())) {
                        level = null;
                        break;
                    }
                    if (!"message".equals(reader.getLocalName())) break;
                }
            }
        }
    }

    class LogXMLWrappingInputStream
    extends InputStream {
        private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><log4j:eventSet version=\"1.2\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">";
        private static final String FOOTER = "</log4j:eventSet>";
        private InputStream[] streams = new InputStream[3];
        int currentStreamIndex = 0;

        private LogXMLWrappingInputStream(InputStream xmlLogFileIs) {
            this.streams[0] = new ByteArrayInputStream(HEADER.getBytes(IOUtils.UTF_8));
            this.streams[1] = xmlLogFileIs;
            this.streams[2] = new ByteArrayInputStream(FOOTER.getBytes(IOUtils.UTF_8));
        }

        @Override
        public int read() throws IOException {
            int c = this.streams[this.currentStreamIndex].read();
            if (c < 0) {
                IOUtils.closeQuietly(this.streams[this.currentStreamIndex]);
                while (this.currentStreamIndex < this.streams.length - 1) {
                    ++this.currentStreamIndex;
                    int tmpC = this.streams[this.currentStreamIndex].read();
                    if (tmpC < 0) {
                        IOUtils.closeQuietly(this.streams[this.currentStreamIndex]);
                        continue;
                    }
                    return tmpC;
                }
                return -1;
            }
            return c;
        }
    }
}

