/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.batch;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.batch.builders.AbstractConsumersBuilder;
import org.apache.tika.batch.builders.BatchProcessBuilder;
import org.apache.tika.eval.AbstractProfiler;
import org.apache.tika.eval.batch.DBConsumersManager;
import org.apache.tika.eval.batch.EvalConsumerBuilder;
import org.apache.tika.eval.db.H2Util;
import org.apache.tika.eval.db.JDBCUtil;
import org.apache.tika.eval.db.MimeBuffer;
import org.apache.tika.eval.langid.LanguageIDWrapper;
import org.apache.tika.util.ClassLoaderUtil;
import org.apache.tika.util.PropsUtil;
import org.apache.tika.util.XMLDOMUtil;
import org.w3c.dom.Node;

public class EvalConsumersBuilder
extends AbstractConsumersBuilder {
    @Override
    public ConsumersManager build(Node node, Map<String, String> runtimeAttributes, ArrayBlockingQueue<FileResource> queue) {
        DBConsumersManager manager;
        LinkedList<FileResourceConsumer> consumers = new LinkedList<FileResourceConsumer>();
        int numConsumers = BatchProcessBuilder.getNumConsumers(runtimeAttributes);
        Map<String, String> localAttrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        Path db = this.getPath(localAttrs, "db");
        String jdbcConnectionString = localAttrs.get("jdbc");
        Path langModelDir = this.getPath(localAttrs, "langModelDir");
        try {
            if (langModelDir == null) {
                LanguageIDWrapper.loadBuiltInModels();
            } else {
                LanguageIDWrapper.loadModels(langModelDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path commonTokens = this.getPath(localAttrs, "commonTokens");
        String defaultLangCode = localAttrs.get("defaultLangCode");
        if (defaultLangCode == null) {
            defaultLangCode = "";
        }
        try {
            AbstractProfiler.loadCommonTokens(commonTokens, defaultLangCode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JDBCUtil jdbcUtil = null;
        if (db != null) {
            jdbcUtil = new H2Util(db);
        } else if (jdbcConnectionString != null) {
            jdbcUtil = new JDBCUtil(jdbcConnectionString, localAttrs.get("jdbcDriver"));
        } else {
            throw new RuntimeException("Must specify: -db or -jdbc");
        }
        EvalConsumerBuilder consumerBuilder = ClassLoaderUtil.buildClass(EvalConsumerBuilder.class, PropsUtil.getString(localAttrs.get("consumerBuilderClass"), null));
        if (consumerBuilder == null) {
            throw new RuntimeException("Must specify consumerBuilderClass in config file");
        }
        boolean forceDrop = PropsUtil.getBoolean(localAttrs.get("drop"), false);
        MimeBuffer mimeBuffer = null;
        try {
            mimeBuffer = consumerBuilder.init(queue, localAttrs, jdbcUtil, forceDrop);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < numConsumers; ++i) {
            try {
                consumers.add(consumerBuilder.build());
                continue;
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            manager = new DBConsumersManager(jdbcUtil, mimeBuffer, consumers);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        consumerBuilder.addErrorLogTablePairs(manager);
        return manager;
    }

    private Path getNonNullPath(Map<String, String> attrs, String key) {
        Path p = this.getPath(attrs, key);
        if (p == null) {
            throw new RuntimeException("Must specify a file for this attribute: " + key);
        }
        return p;
    }

    protected Path getPath(Map<String, String> attrs, String key) {
        String filePath = attrs.get(key);
        if (filePath == null) {
            return null;
        }
        return Paths.get(filePath, new String[0]);
    }
}

