/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.PageLoader;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentMessages;
import org.apache.tapestry5.services.ComponentTemplates;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.apache.tapestry5.services.pageload.PageCachingReferenceTypeService;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;
import org.apache.tapestry5.services.pageload.ReferenceType;
import org.slf4j.Logger;

public class PageSourceImpl
implements PageSource {
    private final ComponentRequestSelectorAnalyzer selectorAnalyzer;
    private final PageLoader pageLoader;
    private final ComponentDependencyRegistry componentDependencyRegistry;
    private final ComponentClassResolver componentClassResolver;
    private final PageClassLoaderContextManager pageClassLoaderContextManager;
    private final PageCachingReferenceTypeService pageCachingReferenceTypeService;
    private final Logger logger;
    private final boolean productionMode;
    private final boolean multipleClassLoaders;
    private final Map<CachedPageKey, Object> pageCache = CollectionFactory.newConcurrentMap();

    public PageSourceImpl(PageLoader pageLoader, ComponentRequestSelectorAnalyzer selectorAnalyzer, ComponentDependencyRegistry componentDependencyRegistry, ComponentClassResolver componentClassResolver, PageClassLoaderContextManager pageClassLoaderContextManager, PageCachingReferenceTypeService pageCachingReferenceTypeService, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, Logger logger) {
        this.pageLoader = pageLoader;
        this.selectorAnalyzer = selectorAnalyzer;
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.componentClassResolver = componentClassResolver;
        this.productionMode = productionMode;
        this.pageCachingReferenceTypeService = pageCachingReferenceTypeService;
        this.multipleClassLoaders = multipleClassLoaders;
        this.pageClassLoaderContextManager = pageClassLoaderContextManager;
        this.logger = logger;
    }

    @Override
    public Page getPage(String canonicalPageName) {
        if (!this.productionMode) {
            this.componentDependencyRegistry.disableInvalidations();
        }
        try {
            Page page = this.getPage(canonicalPageName, true);
            return page;
        }
        finally {
            if (!this.productionMode) {
                this.componentDependencyRegistry.enableInvalidations();
            }
        }
    }

    public Page getPage(String canonicalPageName, boolean invalidateUnknownContext) {
        PageClassLoaderContext context;
        String className;
        ComponentResourceSelector selector = this.selectorAnalyzer.buildSelectorForRequest();
        CachedPageKey key = new CachedPageKey(canonicalPageName, selector);
        while (true) {
            Object object;
            Page page;
            if ((page = this.toPage(object = this.pageCache.get(key))) != null) {
                return page;
            }
            className = this.componentClassResolver.resolvePageNameToClassName(canonicalPageName);
            if (this.multipleClassLoaders) {
                List<String> pageDependencies = this.preprocessPageDependencies(className);
                for (String pageClassName : pageDependencies) {
                    page = this.getPage(this.componentClassResolver.resolvePageClassNameToPageName(pageClassName), false);
                }
            }
            page = this.pageLoader.loadPage(canonicalPageName, selector);
            ReferenceType referenceType = this.pageCachingReferenceTypeService.get(canonicalPageName);
            if (referenceType.equals((Object)ReferenceType.SOFT)) {
                this.pageCache.put(key, new SoftReference<Page>(page));
            } else {
                this.pageCache.put(key, page);
            }
            if (this.productionMode) continue;
            ComponentPageElement rootElement = page.getRootElement();
            this.componentDependencyRegistry.clear(rootElement);
            this.componentDependencyRegistry.register(rootElement);
            context = this.pageClassLoaderContextManager.get(className);
            if (context.isUnknown() && this.multipleClassLoaders) break;
        }
        this.pageCache.remove(key);
        if (invalidateUnknownContext) {
            this.pageClassLoaderContextManager.invalidateAndFireInvalidationEvents(context);
            this.preprocessPageDependencies(className);
        }
        context.getClassNames().clear();
        return this.getPage(canonicalPageName, false);
    }

    private List<String> preprocessPageDependencies(String className) {
        ArrayList<String> pageDependencies = new ArrayList<String>();
        pageDependencies.addAll(new ArrayList<String>(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.INJECT_PAGE)));
        pageDependencies.addAll(new ArrayList<String>(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.SUPERCLASS)));
        Iterator iterator = pageDependencies.iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).contains(".pages.")) continue;
            iterator.remove();
        }
        this.preprocessPageClassLoaderContexts(className, pageDependencies);
        return pageDependencies;
    }

    private void preprocessPageClassLoaderContexts(String className, List<String> pageDependencies) {
        for (int i = 0; i < 5; ++i) {
            this.pageClassLoaderContextManager.get(className);
            for (String pageClassName : pageDependencies) {
                PageClassLoaderContext context = this.pageClassLoaderContextManager.get(pageClassName);
                if (i != 1) continue;
                try {
                    context.getClassLoader().loadClass(pageClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub classesHub, @ComponentTemplates InvalidationEventHub templatesHub, @ComponentMessages InvalidationEventHub messagesHub, ResourceChangeTracker resourceChangeTracker) {
        classesHub.addInvalidationCallback(this::listen);
        templatesHub.addInvalidationCallback(this::listen);
        messagesHub.addInvalidationCallback(this::listen);
        resourceChangeTracker.addInvalidationCallback(this::listen);
    }

    private List<String> listen(List<String> resources) {
        if (resources.isEmpty()) {
            this.clearCache();
        } else {
            for (String className : resources) {
                if (!this.componentClassResolver.isPage(className)) continue;
                String pageName = this.componentClassResolver.resolvePageClassNameToPageName(className);
                Iterator<Map.Entry<CachedPageKey, Object>> iterator = this.pageCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<CachedPageKey, Object> entry = iterator.next();
                    String entryPageName = entry.getKey().pageName;
                    if (!entryPageName.equalsIgnoreCase(pageName)) continue;
                    this.logger.info("Clearing cached page '{}'", (Object)pageName);
                    iterator.remove();
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void clearCache() {
        this.logger.info("Clearing page cache");
        this.pageCache.clear();
    }

    @Override
    public Set<Page> getAllPages() {
        return ((Flow)F.flow(this.pageCache.values()).map((Mapper)new Mapper<Object, Page>(){

            public Page map(Object object) {
                return PageSourceImpl.this.toPage(object);
            }
        }).removeNulls()).toSet();
    }

    private Page toPage(Object object) {
        SoftReference ref;
        Page page = object instanceof SoftReference ? ((ref = (SoftReference)object) == null ? null : (Page)ref.get()) : (Page)object;
        return page;
    }

    private static final class CachedPageKey {
        final String pageName;
        final ComponentResourceSelector selector;

        public CachedPageKey(String pageName, ComponentResourceSelector selector) {
            this.pageName = pageName;
            this.selector = selector;
        }

        public int hashCode() {
            return 37 * this.pageName.hashCode() + this.selector.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachedPageKey)) {
                return false;
            }
            CachedPageKey other = (CachedPageKey)obj;
            return this.pageName.equals(other.pageName) && this.selector.equals(other.selector);
        }

        public String toString() {
            return "CachedPageKey [pageName=" + this.pageName + ", selector=" + this.selector + "]";
        }
    }
}

