/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class Html5DateField
extends AbstractField {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    @Parameter(required=true, principal=true, autoconnect=true)
    private Date value;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(value="componentResources.messages")
    private Messages messages;

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    void beginRender(MarkupWriter writer) {
        String value = this.validationTracker.getInput(this);
        if (value == null) {
            value = this.formatCurrentValue();
        }
        String clientId = this.getClientId();
        writer.element("input", "type", "date", "class", this.cssClass, "name", this.getControlName(), "id", clientId, "value", value);
        this.writeDisabled(writer);
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        writer.end();
    }

    private void writeDisabled(MarkupWriter writer) {
        if (this.isDisabled()) {
            writer.attributes("disabled", "disabled");
        }
    }

    private String formatCurrentValue() {
        if (this.value == null) {
            return "";
        }
        return this.getDateFormat().format(this.value);
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    @Override
    protected void processSubmission(String controlName) {
        String value = this.request.getParameter(controlName);
        this.validationTracker.recordInput(this, value);
        Date parsedValue = null;
        try {
            if (InternalUtils.isNonBlank((String)value)) {
                parsedValue = this.getDateFormat().parse(value);
            }
        }
        catch (ParseException ex) {
            this.validationTracker.recordError(this, this.messages.format("core-date-value-not-parseable", new Object[]{value}));
            return;
        }
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(parsedValue, this.resources, this.validate);
            this.value = parsedValue;
        }
        catch (ValidationException ex) {
            this.validationTracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void injectResources(ComponentResources resources) {
        this.resources = resources;
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }
}

