/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tapestry5.commons.services.InvalidationListener;
import org.apache.tapestry5.commons.util.AvailableValues;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.transform.ControlledPackageType;
import org.slf4j.Logger;

public class ComponentClassResolverImpl
implements ComponentClassResolver,
InvalidationListener {
    private static final String CORE_LIBRARY_PREFIX = "core/";
    private static final Pattern SPLIT_PACKAGE_PATTERN = Pattern.compile("\\.");
    private static final Pattern SPLIT_FOLDER_PATTERN = Pattern.compile("/");
    private static final int LOGICAL_NAME_BUFFER_SIZE = 40;
    private final Logger logger;
    private final ClassNameLocator classNameLocator;
    private final String startPageName;
    private final Map<String, List<String>> libraryNameToPackageNames = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ControlledPackageType> packageNameToType = CollectionFactory.newMap();
    private final Map<String, String> packageNameToLibraryName = CollectionFactory.newMap();
    private volatile boolean needsRebuild = true;
    private final Collection<LibraryMapping> libraryMappings;
    private final Pattern endsWithPagePattern = Pattern.compile(".*/?\\w+page$", 2);
    private volatile Data data = new Data();
    private static final Pattern DOT = Pattern.compile("\\.");

    private boolean endsWithPage(String name) {
        return this.endsWithPagePattern.matcher(name).matches();
    }

    public ComponentClassResolverImpl(Logger logger, ClassNameLocator classNameLocator, @Symbol(value="tapestry.start-page-name") String startPageName, Collection<LibraryMapping> mappings) {
        this.logger = logger;
        this.classNameLocator = classNameLocator;
        this.startPageName = startPageName;
        this.libraryMappings = Collections.unmodifiableCollection(mappings);
        for (LibraryMapping mapping : mappings) {
            String libraryName = mapping.libraryName;
            List packages = this.libraryNameToPackageNames.get(libraryName);
            if (packages == null) {
                packages = CollectionFactory.newList();
                this.libraryNameToPackageNames.put(libraryName, packages);
            }
            packages.add(mapping.rootPackage);
            this.addSubpackagesToPackageMapping(mapping.rootPackage);
            this.packageNameToLibraryName.put(mapping.rootPackage, libraryName);
        }
    }

    private void addSubpackagesToPackageMapping(String rootPackage) {
        for (String subpackage : InternalConstants.SUBPACKAGES) {
            this.packageNameToType.put(rootPackage + "." + subpackage, ControlledPackageType.COMPONENT);
        }
    }

    @Override
    public Map<String, ControlledPackageType> getControlledPackageMapping() {
        return Collections.unmodifiableMap(this.packageNameToType);
    }

    public synchronized void objectWasInvalidated() {
        this.needsRebuild = true;
    }

    private Data getData() {
        if (!this.needsRebuild) {
            return this.data;
        }
        Data newData = new Data();
        for (Map.Entry<String, List<String>> entry : this.libraryNameToPackageNames.entrySet()) {
            List<String> packages = entry.getValue();
            String folder = entry.getKey() + "/";
            for (String packageName : packages) {
                newData.rebuild(folder, packageName);
            }
        }
        newData.validate();
        this.showChanges("pages", this.data.pageToClassName, newData.pageToClassName);
        this.showChanges("components", this.data.componentToClassName, newData.componentToClassName);
        this.showChanges("mixins", this.data.mixinToClassName, newData.mixinToClassName);
        this.needsRebuild = false;
        this.data = newData;
        return this.data;
    }

    private static int countUnique(Map<String, String> map) {
        return CollectionFactory.newSet(map.values()).size();
    }

    private void showChanges(String title, Map<String, String> savedMap, Map<String, String> newMap) {
        if (savedMap.equals(newMap) || !this.logger.isInfoEnabled()) {
            return;
        }
        Map core = CollectionFactory.newMap();
        Map nonCore = CollectionFactory.newMap();
        int maxLength = 0;
        for (String name : newMap.keySet()) {
            if (name.startsWith(CORE_LIBRARY_PREFIX)) {
                String key = name.substring(CORE_LIBRARY_PREFIX.length());
                maxLength = Math.max(maxLength, key.length());
                core.put(key, newMap.get(name));
                continue;
            }
            maxLength = Math.max(maxLength, name.length());
            nonCore.put(name, newMap.get(name));
        }
        core.putAll(nonCore);
        StringBuilder builder = new StringBuilder(2000);
        Formatter f = new Formatter(builder);
        int oldCount = ComponentClassResolverImpl.countUnique(savedMap);
        int newCount = ComponentClassResolverImpl.countUnique(newMap);
        f.format("Available %s (%d", title, newCount);
        if (oldCount > 0 && oldCount != newCount) {
            f.format(", +%d", newCount - oldCount);
        }
        builder.append("):\n");
        String formatString = "%" + maxLength + "s: %s\n";
        List sorted = InternalUtils.sortedKeys((Map)core);
        for (String name : sorted) {
            String className = (String)core.get(name);
            if (name.equals("")) {
                name = "(blank)";
            }
            f.format(formatString, name, className);
        }
        this.logger.info(builder.toString().replaceAll("\\n", System.getProperty("line.separator")));
    }

    @Override
    public String resolvePageNameToClassName(String pageName) {
        Data data = this.getData();
        String result = this.locate(pageName, data.pageToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a page class name.", pageName), new AvailableValues("Page names", this.presentableNames(data.pageToClassName)));
        }
        return result;
    }

    @Override
    public boolean isPageName(String pageName) {
        return this.locate(pageName, this.getData().pageToClassName) != null;
    }

    @Override
    public boolean isPage(String pageClassName) {
        return this.locate(pageClassName, this.getData().pageClassNameToLogicalName) != null;
    }

    @Override
    public List<String> getPageNames() {
        Data data = this.getData();
        List result = CollectionFactory.newList(data.pageClassNameToLogicalName.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getComponentNames() {
        Data data = this.getData();
        List result = CollectionFactory.newList(data.componentToClassName.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getMixinNames() {
        Data data = this.getData();
        List result = CollectionFactory.newList(data.mixinToClassName.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public String resolveComponentTypeToClassName(String componentType) {
        Data data = this.getData();
        String result = this.locate(componentType, data.componentToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a component class name.", componentType), new AvailableValues("Component types", this.presentableNames(data.componentToClassName)));
        }
        return result;
    }

    Collection<String> presentableNames(Map<String, ?> map) {
        Set result = CollectionFactory.newSet();
        for (String name : map.keySet()) {
            if (name.startsWith(CORE_LIBRARY_PREFIX)) {
                result.add(name.substring(CORE_LIBRARY_PREFIX.length()));
                continue;
            }
            result.add(name);
        }
        return result;
    }

    @Override
    public String resolveMixinTypeToClassName(String mixinType) {
        Data data = this.getData();
        String result = this.locate(mixinType, data.mixinToClassName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a mixin class name.", mixinType), new AvailableValues("Mixin types", this.presentableNames(data.mixinToClassName)));
        }
        return result;
    }

    private String locate(String logicalName, Map<String, String> logicalNameToClassName) {
        String result = logicalNameToClassName.get(logicalName);
        if (result != null) {
            return result;
        }
        return logicalNameToClassName.get(CORE_LIBRARY_PREFIX + logicalName);
    }

    @Override
    public String resolvePageClassNameToPageName(String pageClassName) {
        String result = (String)this.getData().pageClassNameToLogicalName.get(pageClassName);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to resolve class name %s to a logical page name.", pageClassName));
        }
        return result;
    }

    @Override
    public String canonicalizePageName(String pageName) {
        Data data = this.getData();
        String result = this.locate(pageName, data.pageNameToCanonicalPageName);
        if (result == null) {
            throw new UnknownValueException(String.format("Unable to resolve '%s' to a known page name.", pageName), new AvailableValues("Page names", this.presentableNames(data.pageNameToCanonicalPageName)));
        }
        return result;
    }

    @Override
    public Map<String, String> getFolderToPackageMapping() {
        Map result = CollectionFactory.newCaseInsensitiveMap();
        for (Map.Entry<String, List<String>> entry : this.libraryNameToPackageNames.entrySet()) {
            String folder = entry.getKey();
            List<String> packageNames = entry.getValue();
            String packageName = ComponentClassResolverImpl.findCommonPackageNameForFolder(folder, packageNames);
            result.put(folder, packageName);
        }
        return result;
    }

    static String findCommonPackageNameForFolder(String folder, List<String> packageNames) {
        String packageName = ComponentClassResolverImpl.findCommonPackageName(packageNames);
        if (packageName == null) {
            throw new RuntimeException(String.format("Package names for library folder '%s' (%s) can not be reduced to a common base package (of at least one term).", folder, InternalUtils.joinSorted(packageNames)));
        }
        return packageName;
    }

    static String findCommonPackageName(List<String> packageNames) {
        String commonPackageName = packageNames.get(0);
        for (int i = 1; i < packageNames.size() && (commonPackageName = ComponentClassResolverImpl.findCommonPackageName(commonPackageName, packageNames.get(i))) != null; ++i) {
        }
        return commonPackageName;
    }

    static String findCommonPackageName(String commonPackageName, String packageName) {
        String[] commonExploded = ComponentClassResolverImpl.explode(commonPackageName);
        String[] exploded = ComponentClassResolverImpl.explode(packageName);
        int count = Math.min(commonExploded.length, exploded.length);
        int commonLength = 0;
        int commonTerms = 0;
        for (int i = 0; i < count && exploded[i].equals(commonExploded[i]); ++i) {
            commonLength += exploded[i].length() + (i == 0 ? 0 : 1);
            ++commonTerms;
        }
        if (commonTerms < 1) {
            return null;
        }
        return commonPackageName.substring(0, commonLength);
    }

    private static String[] explode(String packageName) {
        return DOT.split(packageName);
    }

    @Override
    public List<String> getLibraryNames() {
        return ((Flow)F.flow(this.libraryNameToPackageNames.keySet()).remove(F.IS_BLANK)).sort().toList();
    }

    @Override
    public String getLibraryNameForClass(String className) {
        int dotx;
        String libraryName;
        assert (className != null);
        String current = className;
        do {
            if ((dotx = current.lastIndexOf(46)) >= 1) continue;
            throw new IllegalArgumentException(String.format("Class %s is not inside any package associated with any library.", className));
        } while ((libraryName = this.packageNameToLibraryName.get(current = current.substring(0, dotx))) == null);
        return libraryName;
    }

    @Override
    public Collection<LibraryMapping> getLibraryMappings() {
        return this.libraryMappings;
    }

    private class Data {
        private final Map<String, String> pageToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> componentToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> mixinToClassName = CollectionFactory.newCaseInsensitiveMap();
        private final Map<String, String> pageClassNameToLogicalName = CollectionFactory.newMap();
        private final Map<String, String> pageNameToCanonicalPageName = CollectionFactory.newCaseInsensitiveMap();
        private Map<String, Set<String>> pageToClassNames = CollectionFactory.newCaseInsensitiveMap();
        private Map<String, Set<String>> componentToClassNames = CollectionFactory.newCaseInsensitiveMap();
        private Map<String, Set<String>> mixinToClassNames = CollectionFactory.newCaseInsensitiveMap();
        private boolean invalid = false;

        private Data() {
        }

        private void rebuild(String pathPrefix, String rootPackage) {
            this.fill(pathPrefix, rootPackage, "pages", this.pageToClassName, this.pageToClassNames);
            this.fill(pathPrefix, rootPackage, "components", this.componentToClassName, this.componentToClassNames);
            this.fill(pathPrefix, rootPackage, "mixins", this.mixinToClassName, this.mixinToClassNames);
        }

        private void fill(String pathPrefix, String rootPackage, String subPackage, Map<String, String> logicalNameToClassName, Map<String, Set<String>> nameToClassNames) {
            String searchPackage = rootPackage + "." + subPackage;
            boolean isPage = subPackage.equals("pages");
            Collection classNames = ComponentClassResolverImpl.this.classNameLocator.locateClassNames(searchPackage);
            Set aliases = CollectionFactory.newSet();
            int startPos = searchPackage.length() + 1;
            for (String className : classNames) {
                aliases.clear();
                String logicalName = this.toLogicalName(className, pathPrefix, startPos, true);
                String unstrippedName = this.toLogicalName(className, pathPrefix, startPos, false);
                aliases.add(logicalName);
                aliases.add(unstrippedName);
                if (isPage) {
                    int lastSlashx;
                    String lastTerm;
                    if (ComponentClassResolverImpl.this.endsWithPage(logicalName)) {
                        logicalName = logicalName.substring(0, logicalName.length() - 4);
                        aliases.add(logicalName);
                    }
                    String string = lastTerm = (lastSlashx = logicalName.lastIndexOf("/")) < 0 ? logicalName : logicalName.substring(lastSlashx + 1);
                    if (lastTerm.equalsIgnoreCase("index")) {
                        String reducedName = lastSlashx < 0 ? "" : logicalName.substring(0, lastSlashx);
                        aliases.add(reducedName);
                    }
                    if (logicalName.equals(ComponentClassResolverImpl.this.startPageName)) {
                        aliases.add("");
                    }
                    this.pageClassNameToLogicalName.put(className, logicalName);
                }
                for (String alias : aliases) {
                    logicalNameToClassName.put(alias, className);
                    this.addNameMapping(nameToClassNames, alias, className);
                    if (!isPage) continue;
                    this.pageNameToCanonicalPageName.put(alias, logicalName);
                }
            }
        }

        private String toLogicalName(String className, String pathPrefix, int startPos, boolean stripTerms) {
            String logicalName;
            List terms = CollectionFactory.newList();
            this.addAll(terms, SPLIT_FOLDER_PATTERN, pathPrefix);
            this.addAll(terms, SPLIT_PACKAGE_PATTERN, className.substring(startPos));
            StringBuilder builder = new StringBuilder(40);
            String sep = "";
            String unstripped = logicalName = (String)terms.remove(terms.size() - 1);
            for (String term : terms) {
                builder.append(sep);
                builder.append(term);
                sep = "/";
                if (!stripTerms) continue;
                logicalName = this.stripTerm(term, logicalName);
            }
            if (logicalName.equals("")) {
                logicalName = unstripped;
            }
            builder.append(sep);
            builder.append(logicalName);
            return builder.toString();
        }

        private void addAll(List<String> terms, Pattern splitter, String input) {
            for (String term : splitter.split(input)) {
                if (term.equals("")) continue;
                terms.add(term);
            }
        }

        private String stripTerm(String term, String logicalName) {
            if (this.isCaselessPrefix(term, logicalName)) {
                logicalName = logicalName.substring(term.length());
            }
            if (this.isCaselessSuffix(term, logicalName)) {
                logicalName = logicalName.substring(0, logicalName.length() - term.length());
            }
            return logicalName;
        }

        private boolean isCaselessPrefix(String prefix, String string) {
            return string.regionMatches(true, 0, prefix, 0, prefix.length());
        }

        private boolean isCaselessSuffix(String suffix, String string) {
            return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
        }

        private void addNameMapping(Map<String, Set<String>> map, String name, String className) {
            Set classNames = map.get(name);
            if (classNames == null) {
                classNames = CollectionFactory.newSet();
                map.put(name, classNames);
            }
            classNames.add(className);
        }

        private void validate() {
            this.validate("page name", this.pageToClassNames);
            this.validate("component type", this.componentToClassNames);
            this.validate("mixin type", this.mixinToClassNames);
            this.pageToClassNames = null;
            this.componentToClassNames = null;
            this.mixinToClassNames = null;
            if (this.invalid) {
                throw new IllegalStateException("You must correct these validation issues to proceed.");
            }
        }

        private void validate(String category, Map<String, Set<String>> map) {
            boolean header = false;
            for (String name : F.flow(map.keySet()).sort()) {
                Set<String> classNames = map.get(name);
                if (classNames.size() == 1) continue;
                if (!header) {
                    ComponentClassResolverImpl.this.logger.error(String.format("Some %s(s) map to more than one Java class.", category));
                    header = true;
                    this.invalid = true;
                }
                ComponentClassResolverImpl.this.logger.error(String.format("%s '%s' maps to %s", InternalUtils.capitalize((String)category), name, InternalUtils.joinSorted(classNames)));
            }
        }
    }
}

