/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Map;
import org.apache.tapestry5.ioc.def.ContributionDef;

public class MappedConfigurationOverride<K, V> {
    private final Map<K, V> configuration;
    private final K key;
    private final V overrideValue;
    private final ContributionDef contribDef;

    public MappedConfigurationOverride(ContributionDef contribDef, Map<K, V> configuration, K key, V overrideValue) {
        this.contribDef = contribDef;
        this.configuration = configuration;
        this.key = key;
        this.overrideValue = overrideValue;
    }

    void apply() {
        if (!this.configuration.containsKey(this.key)) {
            throw new IllegalArgumentException(String.format("Override for key %s (at %s) does not match an existing key.", this.key, this.contribDef));
        }
        if (this.overrideValue == null) {
            this.configuration.remove(this.key);
        } else {
            this.configuration.put(this.key, this.overrideValue);
        }
    }

    public ContributionDef getContribDef() {
        return this.contribDef;
    }
}

