/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tapestry5.http.ContentType;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResponseCustomizer;
import org.apache.tapestry5.services.assets.StreamableResource;

public class StreamableResourceImpl
implements StreamableResource {
    protected final String description;
    private final ContentType contentType;
    protected final CompressionStatus compression;
    protected final long lastModified;
    protected final BytestreamCache bytestreamCache;
    protected final AssetChecksumGenerator assetChecksumGenerator;
    protected final ResponseCustomizer responseCustomizer;

    public StreamableResourceImpl(String description, ContentType contentType, CompressionStatus compression, long lastModified, BytestreamCache bytestreamCache, AssetChecksumGenerator assetChecksumGenerator, ResponseCustomizer responseCustomizer) {
        this.lastModified = lastModified;
        this.description = description;
        this.bytestreamCache = bytestreamCache;
        this.contentType = contentType;
        this.compression = compression;
        this.assetChecksumGenerator = assetChecksumGenerator;
        this.responseCustomizer = responseCustomizer;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CompressionStatus getCompression() {
        return this.compression;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public int getSize() {
        return this.bytestreamCache.size();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void streamTo(OutputStream os) throws IOException {
        this.bytestreamCache.writeTo(os);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.bytestreamCache.openStream();
    }

    public String toString() {
        return String.format("StreamableResource<%s %s %s lastModified: %tc size: %d>", this.contentType, this.description, this.compression.name(), this.lastModified, this.getSize());
    }

    @Override
    public String getChecksum() throws IOException {
        return this.assetChecksumGenerator.generateChecksum(this);
    }

    @Override
    public StreamableResource addResponseCustomizer(final ResponseCustomizer customizer) {
        final ResponseCustomizer oldCustomizer = this.responseCustomizer;
        if (oldCustomizer == null) {
            return this.withNewResourceCustomizer(customizer);
        }
        return this.withNewResourceCustomizer(new ResponseCustomizer(){

            @Override
            public void customizeResponse(StreamableResource resource, Response response) throws IOException {
                oldCustomizer.customizeResponse(resource, response);
                customizer.customizeResponse(resource, response);
            }
        });
    }

    @Override
    public ResponseCustomizer getResponseCustomizer() {
        return this.responseCustomizer;
    }

    @Override
    public StreamableResource withContentType(ContentType newContentType) {
        return new StreamableResourceImpl(this.description, newContentType, this.compression, this.lastModified, this.bytestreamCache, this.assetChecksumGenerator, this.responseCustomizer);
    }

    private StreamableResourceImpl withNewResourceCustomizer(ResponseCustomizer customizer) {
        return new StreamableResourceImpl(this.description, this.contentType, this.compression, this.lastModified, this.bytestreamCache, this.assetChecksumGenerator, customizer);
    }
}

