/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry5.http.ContentType;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

public class JSONArrayEventResultProcessor
implements ComponentEventResultProcessor<JSONArray> {
    private final Response response;
    private final boolean compactJSON;
    private final ContentType contentType;

    public JSONArrayEventResultProcessor(Response response, @Symbol(value="tapestry.charset") String outputEncoding, @Symbol(value="tapestry.compact-json") boolean compactJSON) {
        this.response = response;
        this.compactJSON = compactJSON;
        this.contentType = new ContentType("application/json").withCharset(outputEncoding);
    }

    @Override
    public void processResultValue(JSONArray value) throws IOException {
        PrintWriter pw = this.response.getPrintWriter(this.contentType.toString());
        value.print(pw, this.compactJSON);
        pw.close();
    }
}

