/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.internal.services.StringInterner;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.AvailableValues;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.Stack;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.bindings.LiteralBinding;
import org.apache.tapestry5.internal.pageload.AssemblerContext;
import org.apache.tapestry5.internal.pageload.ComponentAssembler;
import org.apache.tapestry5.internal.pageload.ComponentAssemblerImpl;
import org.apache.tapestry5.internal.pageload.ComponentAssemblerSource;
import org.apache.tapestry5.internal.pageload.EmbeddedComponentAssembler;
import org.apache.tapestry5.internal.pageload.PageAssembly;
import org.apache.tapestry5.internal.pageload.PageAssemblyAction;
import org.apache.tapestry5.internal.pageload.ParameterBinder;
import org.apache.tapestry5.internal.pageload.RenderBodyElement;
import org.apache.tapestry5.internal.pageload.TokenStream;
import org.apache.tapestry5.internal.pageload.TokenStreamImpl;
import org.apache.tapestry5.internal.parser.AttributeToken;
import org.apache.tapestry5.internal.parser.BlockToken;
import org.apache.tapestry5.internal.parser.CDATAToken;
import org.apache.tapestry5.internal.parser.CommentToken;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.parser.DTDToken;
import org.apache.tapestry5.internal.parser.DefineNamespacePrefixToken;
import org.apache.tapestry5.internal.parser.ExpansionToken;
import org.apache.tapestry5.internal.parser.ExtensionPointToken;
import org.apache.tapestry5.internal.parser.ParameterToken;
import org.apache.tapestry5.internal.parser.StartComponentToken;
import org.apache.tapestry5.internal.parser.StartElementToken;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.parser.TextToken;
import org.apache.tapestry5.internal.parser.TokenType;
import org.apache.tapestry5.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry5.internal.services.ComponentTemplateSource;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.services.PageElementFactory;
import org.apache.tapestry5.internal.services.PageLoader;
import org.apache.tapestry5.internal.services.PersistentFieldManager;
import org.apache.tapestry5.internal.structure.BlockImpl;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.internal.structure.ComponentPageElementResourcesSource;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.structure.PageImpl;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentMessages;
import org.apache.tapestry5.services.ComponentTemplates;
import org.apache.tapestry5.services.MetaDataLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class PageLoaderImpl
implements PageLoader,
ComponentAssemblerSource {
    private static final PageAssemblyAction POP_EMBEDDED_COMPONENT_ACTION = new PageAssemblyAction(){

        @Override
        public void execute(PageAssembly pageAssembly) {
            pageAssembly.createdElement.pop();
            pageAssembly.bodyElement.pop();
            pageAssembly.embeddedAssembler.pop();
        }
    };
    private static final RenderCommand END_ELEMENT = new RenderCommand(){

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            writer.end();
        }

        public String toString() {
            return "End";
        }
    };
    private final Map<Key, ComponentAssembler> cache = CollectionFactory.newConcurrentMap();
    private final ComponentInstantiatorSource instantiatorSource;
    private final ComponentTemplateSource templateSource;
    private final PageElementFactory elementFactory;
    private final ComponentPageElementResourcesSource resourcesSource;
    private final ComponentClassResolver componentClassResolver;
    private final PersistentFieldManager persistentFieldManager;
    private final StringInterner interner;
    private final OperationTracker tracker;
    private final PerthreadManager perThreadManager;
    private final Logger logger;
    private final MetaDataLocator metaDataLocator;
    private final RequestGlobals requestGlobals;

    public PageLoaderImpl(ComponentInstantiatorSource instantiatorSource, ComponentTemplateSource templateSource, PageElementFactory elementFactory, ComponentPageElementResourcesSource resourcesSource, ComponentClassResolver componentClassResolver, PersistentFieldManager persistentFieldManager, StringInterner interner, OperationTracker tracker, PerthreadManager perThreadManager, Logger logger, MetaDataLocator metaDataLocator, RequestGlobals requestGlobals) {
        this.instantiatorSource = instantiatorSource;
        this.templateSource = templateSource;
        this.elementFactory = elementFactory;
        this.resourcesSource = resourcesSource;
        this.componentClassResolver = componentClassResolver;
        this.persistentFieldManager = persistentFieldManager;
        this.interner = interner;
        this.tracker = tracker;
        this.perThreadManager = perThreadManager;
        this.logger = logger;
        this.metaDataLocator = metaDataLocator;
        this.requestGlobals = requestGlobals;
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub classesHub, @ComponentTemplates InvalidationEventHub templatesHub, @ComponentMessages InvalidationEventHub messagesHub) {
        classesHub.clearOnInvalidation(this.cache);
        templatesHub.clearOnInvalidation(this.cache);
        messagesHub.clearOnInvalidation(this.cache);
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Page loadPage(final String logicalPageName, final ComponentResourceSelector selector) {
        final String pageClassName = this.componentClassResolver.resolvePageNameToClassName(logicalPageName);
        final long startTime = System.nanoTime();
        return (Page)this.tracker.invoke("Constructing instance of page class " + pageClassName, (Invokable)new Invokable<Page>(){

            public Page invoke() {
                PageImpl page = new PageImpl(logicalPageName, selector, PageLoaderImpl.this.persistentFieldManager, PageLoaderImpl.this.perThreadManager, PageLoaderImpl.this.metaDataLocator);
                ComponentAssembler assembler = PageLoaderImpl.this.getAssembler(pageClassName, selector);
                ComponentPageElement rootElement = assembler.assembleRootComponent(page);
                page.setRootElement(rootElement);
                page.loaded();
                long elapsedTime = System.nanoTime() - startTime;
                double elapsedMS = (double)elapsedTime * 1.0E-6;
                if (PageLoaderImpl.this.logger.isInfoEnabled()) {
                    PageLoaderImpl.this.logger.info(String.format("Loaded page '%s' (%s) in %.3f ms", logicalPageName, selector.toShortString(), elapsedMS));
                }
                Page.Stats roughStats = page.getStats();
                page.setStats(new Page.Stats(elapsedMS, roughStats.componentCount, roughStats.weight));
                return page;
            }
        });
    }

    @Override
    public ComponentAssembler getAssembler(String className, ComponentResourceSelector selector) {
        Key key = new Key(className, selector);
        ComponentAssembler result = this.cache.get(key);
        if (result == null) {
            result = this.createAssembler(className, selector);
            this.cache.put(key, result);
        }
        return result;
    }

    private ComponentAssembler createAssembler(final String className, final ComponentResourceSelector selector) {
        return (ComponentAssembler)this.tracker.invoke("Creating ComponentAssembler for " + className, (Invokable)new Invokable<ComponentAssembler>(){

            public ComponentAssembler invoke() {
                Instantiator instantiator = PageLoaderImpl.this.instantiatorSource.getInstantiator(className);
                ComponentModel componentModel = instantiator.getModel();
                ComponentTemplate template = PageLoaderImpl.this.templateSource.getTemplate(componentModel, selector);
                ComponentPageElementResources resources = PageLoaderImpl.this.resourcesSource.get(selector);
                ComponentAssemblerImpl assembler = new ComponentAssemblerImpl(PageLoaderImpl.this, PageLoaderImpl.this.instantiatorSource, PageLoaderImpl.this.componentClassResolver, instantiator, resources, PageLoaderImpl.this.tracker, template.usesStrictMixinParameters());
                PageLoaderImpl.this.programAssembler(assembler, template);
                return assembler;
            }
        });
    }

    private void programAssembler(ComponentAssembler assembler, ComponentTemplate template) {
        TokenStream stream = this.createTokenStream(assembler, template);
        AssemblerContext context = new AssemblerContext(assembler, stream, template.usesStrictMixinParameters());
        if (template.isMissing()) {
            this.body(context);
            return;
        }
        while (context.more()) {
            this.processTemplateToken(context);
        }
        context.flushComposable();
    }

    private TokenStream createTokenStream(ComponentAssembler assembler, ComponentTemplate template) {
        List tokens = CollectionFactory.newList();
        Stack queue = CollectionFactory.newStack();
        List<ComponentTemplate> overrideSearch = this.buildOverrideSearch(assembler, template);
        ComponentTemplate baseTemplate = PageLoaderImpl.getLast(overrideSearch);
        this.pushAll((Stack<TemplateToken>)queue, baseTemplate.getTokens());
        while (!queue.isEmpty()) {
            TemplateToken token = (TemplateToken)((Object)queue.pop());
            if (token.getTokenType().equals((Object)TokenType.EXTENSION_POINT)) {
                ExtensionPointToken extensionPointToken = (ExtensionPointToken)token;
                this.queueOverrideTokensForExtensionPoint(extensionPointToken, (Stack<TemplateToken>)queue, overrideSearch);
                continue;
            }
            tokens.add(token);
        }
        Collections.reverse(overrideSearch);
        Map componentIds = CollectionFactory.newCaseInsensitiveMap();
        for (ComponentTemplate ct : overrideSearch) {
            componentIds.putAll(ct.getComponentIds());
        }
        assembler.validateEmbeddedIds(componentIds, template.getResource());
        return new TokenStreamImpl(tokens);
    }

    private static <T> T getLast(List<T> list) {
        int count = list.size();
        return list.get(count - 1);
    }

    private void queueOverrideTokensForExtensionPoint(ExtensionPointToken extensionPointToken, Stack<TemplateToken> queue, List<ComponentTemplate> overrideSearch) {
        String extensionPointId = extensionPointToken.getExtensionPointId();
        for (ComponentTemplate t : overrideSearch) {
            List<TemplateToken> tokens = t.getExtensionPointTokens(extensionPointId);
            if (tokens == null) continue;
            this.pushAll(queue, tokens);
            return;
        }
        throw new TapestryException(String.format("Could not find an override for extension point '%s'.", extensionPointId), extensionPointToken.getLocation(), null);
    }

    private List<ComponentTemplate> buildOverrideSearch(ComponentAssembler assembler, ComponentTemplate template) {
        List result = CollectionFactory.newList();
        result.add(template);
        ComponentModel model = assembler.getModel();
        ComponentTemplate lastTemplate = template;
        while (lastTemplate.isExtension()) {
            ComponentModel parentModel = model.getParentModel();
            if (parentModel == null) {
                throw new RuntimeException(String.format("Component %s uses an extension template, but does not have a parent component.", model.getComponentClassName()));
            }
            ComponentTemplate parentTemplate = this.templateSource.getTemplate(parentModel, assembler.getSelector());
            result.add(parentTemplate);
            lastTemplate = parentTemplate;
            model = parentModel;
        }
        return result;
    }

    private void pushAll(Stack<TemplateToken> queue, List<TemplateToken> tokens) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            queue.push((Object)tokens.get(i));
        }
    }

    private void processTemplateToken(AssemblerContext context) {
        switch (context.peekType()) {
            case TEXT: {
                this.text(context);
                break;
            }
            case EXPANSION: {
                this.expansion(context);
                break;
            }
            case BODY: {
                context.next();
                this.body(context);
                break;
            }
            case START_ELEMENT: {
                this.element(context);
                break;
            }
            case START_COMPONENT: {
                this.component(context);
                break;
            }
            case COMMENT: {
                this.comment(context);
                break;
            }
            case BLOCK: {
                this.block(context);
                break;
            }
            case PARAMETER: {
                this.parameter(context);
                break;
            }
            case DTD: {
                this.dtd(context);
                break;
            }
            case DEFINE_NAMESPACE_PREFIX: {
                this.defineNamespacePrefix(context);
                break;
            }
            case CDATA: {
                this.cdata(context);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Not yet implemented: %s", context.peekType().toString()));
            }
        }
    }

    private void cdata(AssemblerContext context) {
        CDATAToken token = context.next(CDATAToken.class);
        context.addComposable(token);
    }

    private void defineNamespacePrefix(AssemblerContext context) {
        DefineNamespacePrefixToken token = context.next(DefineNamespacePrefixToken.class);
        context.addComposable(token);
    }

    private void dtd(AssemblerContext context) {
        final DTDToken token = context.next(DTDToken.class);
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                if (!pageAssembly.checkAndSetFlag("dtd-page-element-added")) {
                    pageAssembly.addRenderCommand(token);
                }
            }
        });
    }

    private void parameter(AssemblerContext context) {
        final ParameterToken token = context.next(ParameterToken.class);
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                String parameterName = token.name;
                ComponentPageElement element = (ComponentPageElement)pageAssembly.createdElement.peek();
                Location location = token.getLocation();
                BlockImpl block = new BlockImpl(location, PageLoaderImpl.this.interner.format("Parameter %s of %s", new Object[]{parameterName, element.getCompleteId()}));
                LiteralBinding binding = new LiteralBinding(location, "block parameter " + parameterName, block);
                EmbeddedComponentAssembler embeddedAssembler = (EmbeddedComponentAssembler)pageAssembly.embeddedAssembler.peek();
                ParameterBinder binder = embeddedAssembler.createParameterBinder(parameterName);
                if (binder == null) {
                    throw new UnknownValueException(String.format("Component %s does not include a formal parameter '%s' (and does not support informal parameters).", element.getCompleteId(), parameterName), (Object)location, null, new AvailableValues("Formal parameters", embeddedAssembler.getFormalParameterNames()));
                }
                binder.bind((ComponentPageElement)pageAssembly.createdElement.peek(), binding);
                pageAssembly.bodyElement.push((Object)block);
            }
        });
        this.consumeToEndElementAndPopBodyElement(context);
    }

    private void block(AssemblerContext context) {
        final BlockToken token = context.next(BlockToken.class);
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                String blockId = token.getId();
                ComponentPageElement element = (ComponentPageElement)pageAssembly.activeElement.peek();
                String description = blockId == null ? PageLoaderImpl.this.interner.format("Anonymous within %s", new Object[]{element.getCompleteId()}) : PageLoaderImpl.this.interner.format("%s within %s", new Object[]{blockId, element.getCompleteId()});
                BlockImpl block = new BlockImpl(token.getLocation(), description);
                if (blockId != null) {
                    element.addBlock(blockId, block);
                }
                pageAssembly.bodyElement.push((Object)block);
            }
        });
        this.consumeToEndElementAndPopBodyElement(context);
    }

    private void consumeToEndElementAndPopBodyElement(AssemblerContext context) {
        while (true) {
            switch (context.peekType()) {
                case END_ELEMENT: {
                    context.next();
                    context.add(new PageAssemblyAction(){

                        @Override
                        public void execute(PageAssembly pageAssembly) {
                            pageAssembly.bodyElement.pop();
                        }
                    });
                    return;
                }
            }
            this.processTemplateToken(context);
        }
    }

    private void comment(AssemblerContext context) {
        CommentToken token = context.next(CommentToken.class);
        context.addComposable(token);
    }

    private void component(AssemblerContext context) {
        EmbeddedComponentAssembler embeddedAssembler = this.startComponent(context);
        block4: while (true) {
            switch (context.peekType()) {
                case ATTRIBUTE: {
                    this.bindAttributeAsParameter(context, embeddedAssembler);
                    continue block4;
                }
                case END_ELEMENT: {
                    context.next();
                    context.add(POP_EMBEDDED_COMPONENT_ACTION);
                    return;
                }
            }
            this.processTemplateToken(context);
        }
    }

    private void bindAttributeAsParameter(AssemblerContext context, EmbeddedComponentAssembler embeddedAssembler) {
        AttributeToken token = context.next(AttributeToken.class);
        this.addParameterBindingAction(context, embeddedAssembler, token.name, token.value, "literal", token.getLocation(), true);
    }

    private void element(AssemblerContext context) {
        StartElementToken token = context.next(StartElementToken.class);
        context.addComposable(token);
        block4: while (true) {
            switch (context.peekType()) {
                case ATTRIBUTE: {
                    this.attribute(context);
                    continue block4;
                }
                case END_ELEMENT: {
                    context.next();
                    context.addComposable(END_ELEMENT);
                    return;
                }
            }
            this.processTemplateToken(context);
        }
    }

    private EmbeddedComponentAssembler startComponent(AssemblerContext context) {
        EmbeddedComponentModel embeddedModel;
        StartComponentToken token = context.next(StartComponentToken.class);
        ComponentAssembler assembler = context.assembler;
        String elementName = token.getElementName();
        String embeddedType = token.getComponentType();
        String embeddedId = token.getId();
        String embeddedComponentClassName = null;
        EmbeddedComponentModel embeddedComponentModel = embeddedModel = embeddedId == null ? null : assembler.getModel().getEmbeddedComponentModel(embeddedId);
        if (embeddedId == null) {
            embeddedId = assembler.generateEmbeddedId(embeddedType);
        }
        if (embeddedModel != null) {
            String modelType = embeddedModel.getComponentType();
            if (InternalUtils.isNonBlank((String)modelType) && embeddedType != null) {
                throw new TapestryException(String.format("Embedded component '%s' provides a type attribute in the template ('%s') as well as in the component class ('%s'). You should not provide a type attribute in the template when defining an embedded component within the component class.", embeddedId, embeddedType, modelType), (Object)token, null);
            }
            embeddedType = modelType;
            embeddedComponentClassName = embeddedModel.getComponentClassName();
        }
        String componentClassName = embeddedComponentClassName;
        if (InternalUtils.isNonBlank((String)embeddedType)) {
            try {
                componentClassName = this.componentClassResolver.resolveComponentTypeToClassName(embeddedType);
            }
            catch (RuntimeException ex) {
                throw new TapestryException(ex.getMessage(), (Object)token, (Throwable)ex);
            }
        }
        EmbeddedComponentAssembler embeddedAssembler = assembler.createEmbeddedAssembler(embeddedId, componentClassName, embeddedModel, token.getMixins(), token.getLocation());
        this.addActionForEmbeddedComponent(context, embeddedAssembler, embeddedId, elementName, componentClassName);
        this.addParameterBindingActions(context, embeddedAssembler, embeddedModel);
        if (embeddedModel != null && embeddedModel.getInheritInformalParameters()) {
            assembler.add(new PageAssemblyAction(){

                @Override
                public void execute(PageAssembly pageAssembly) {
                    final ComponentPageElement container = (ComponentPageElement)pageAssembly.activeElement.peek();
                    final ComponentPageElement embedded = (ComponentPageElement)pageAssembly.createdElement.peek();
                    pageAssembly.deferred.add(new PageAssemblyAction(){

                        @Override
                        public void execute(PageAssembly pageAssembly) {
                            PageLoaderImpl.this.copyInformalParameters(container, embedded);
                        }
                    });
                }
            });
        }
        return embeddedAssembler;
    }

    private void copyInformalParameters(ComponentPageElement container, ComponentPageElement embedded) {
        ComponentModel model = embedded.getComponentResources().getComponentModel();
        Map informals = container.getInformalParameterBindings();
        for (String name : informals.keySet()) {
            if (model.getParameterModel(name) != null) continue;
            Binding binding = (Binding)informals.get(name);
            embedded.bindParameter(name, binding);
        }
    }

    private void addParameterBindingActions(AssemblerContext context, EmbeddedComponentAssembler embeddedAssembler, EmbeddedComponentModel embeddedModel) {
        if (embeddedModel == null) {
            return;
        }
        for (String parameterName : embeddedModel.getParameterNames()) {
            String parameterValue = embeddedModel.getParameterValue(parameterName);
            this.addParameterBindingAction(context, embeddedAssembler, parameterName, parameterValue, "prop", embeddedModel.getLocation(), false);
        }
    }

    private void addParameterBindingAction(AssemblerContext context, final EmbeddedComponentAssembler embeddedAssembler, final String parameterName, final String parameterValue, final String metaDefaultBindingPrefix, final Location location, final boolean ignoreUnmatchedFormal) {
        if (embeddedAssembler.isBound(parameterName)) {
            return;
        }
        embeddedAssembler.setBound(parameterName);
        if (parameterValue.startsWith("inherit:")) {
            String containerParameterName = parameterValue.substring("inherit:".length());
            this.addInheritedBindingAction(context, parameterName, containerParameterName);
            return;
        }
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                ParameterBinder binder = embeddedAssembler.createParameterBinder(parameterName);
                if (binder == null) {
                    if (ignoreUnmatchedFormal) {
                        return;
                    }
                    throw new UnknownValueException(String.format("Component %s does not include a formal parameter '%s' (and does not support informal parameters).", ((ComponentPageElement)pageAssembly.createdElement.peek()).getCompleteId(), parameterName), null, null, new AvailableValues("Formal parameters", embeddedAssembler.getFormalParameterNames()));
                }
                String defaultBindingPrefix = binder.getDefaultBindingPrefix(metaDefaultBindingPrefix);
                InternalComponentResources containerResources = ((ComponentPageElement)pageAssembly.activeElement.peek()).getComponentResources();
                ComponentPageElement embeddedElement = (ComponentPageElement)pageAssembly.createdElement.peek();
                InternalComponentResources embeddedResources = embeddedElement.getComponentResources();
                Binding binding = PageLoaderImpl.this.elementFactory.newBinding(parameterName, containerResources, embeddedResources, defaultBindingPrefix, parameterValue, location);
                binder.bind(embeddedElement, binding);
            }
        });
    }

    private void addInheritedBindingAction(AssemblerContext context, final String parameterName, final String containerParameterName) {
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                final ComponentPageElement container = (ComponentPageElement)pageAssembly.activeElement.peek();
                final ComponentPageElement embedded = (ComponentPageElement)pageAssembly.createdElement.peek();
                pageAssembly.deferred.add(new PageAssemblyAction(){

                    @Override
                    public void execute(PageAssembly pageAssembly) {
                        PageLoaderImpl.this.connectInheritedParameter(container, embedded, parameterName, containerParameterName);
                    }
                });
            }
        });
    }

    private void connectInheritedParameter(ComponentPageElement container, ComponentPageElement embedded, String parameterName, String containerParameterName) {
        Binding containerBinding = container.getBinding(containerParameterName);
        if (containerBinding == null) {
            return;
        }
        embedded.bindParameter(parameterName, containerBinding);
    }

    private void addActionForEmbeddedComponent(AssemblerContext context, final EmbeddedComponentAssembler embeddedAssembler, final String embeddedId, final String elementName, final String componentClassName) {
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                pageAssembly.checkForRecursion(componentClassName, embeddedAssembler.getLocation());
                ComponentResourceSelector selector = pageAssembly.page.getSelector();
                ComponentAssembler assemblerForSubcomponent = PageLoaderImpl.this.getAssembler(componentClassName, selector);
                assemblerForSubcomponent.assembleEmbeddedComponent(pageAssembly, embeddedAssembler, embeddedId, elementName, embeddedAssembler.getLocation());
                ComponentPageElement embeddedElement = (ComponentPageElement)pageAssembly.createdElement.peek();
                pageAssembly.addRenderCommand(embeddedElement);
                pageAssembly.bodyElement.push((Object)embeddedElement);
                pageAssembly.embeddedAssembler.push((Object)embeddedAssembler);
            }
        });
    }

    private void attribute(AssemblerContext context) {
        final AttributeToken token = context.next(AttributeToken.class);
        String value = token.value;
        if (value.indexOf("${") < 0) {
            context.addComposable(token);
            return;
        }
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                ++pageAssembly.weight;
                InternalComponentResources resources = ((ComponentPageElement)pageAssembly.activeElement.peek()).getComponentResources();
                RenderCommand command = PageLoaderImpl.this.elementFactory.newAttributeElement(resources, token);
                pageAssembly.addRenderCommand(command);
            }
        });
    }

    private void body(AssemblerContext context) {
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                ComponentPageElement element = (ComponentPageElement)pageAssembly.activeElement.peek();
                pageAssembly.addRenderCommand(new RenderBodyElement(element));
            }
        });
    }

    private void expansion(AssemblerContext context) {
        final ExpansionToken token = context.next(ExpansionToken.class);
        context.add(new PageAssemblyAction(){

            @Override
            public void execute(PageAssembly pageAssembly) {
                InternalComponentResources resources = ((ComponentPageElement)pageAssembly.activeElement.peek()).getComponentResources();
                RenderCommand command = PageLoaderImpl.this.elementFactory.newExpansionElement(resources, token);
                pageAssembly.addRenderCommand(command);
            }
        });
    }

    private void text(AssemblerContext context) {
        TextToken textToken = context.next(TextToken.class);
        context.addComposable(textToken);
    }

    private static final class Key {
        private final String className;
        private final ComponentResourceSelector selector;

        private Key(String className, ComponentResourceSelector selector) {
            this.className = className;
            this.selector = selector;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.className.equals(key.className) && this.selector.equals(key.selector);
        }

        public int hashCode() {
            return 31 * this.className.hashCode() + this.selector.hashCode();
        }
    }
}

