/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.commons.Configuration;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.annotations.Advise;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Decorate;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.annotations.Optional;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.Startup;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.StartupDef;
import org.apache.tapestry5.ioc.internal.AdvisorDefImpl;
import org.apache.tapestry5.ioc.internal.ConfigurationType;
import org.apache.tapestry5.ioc.internal.ContributionDefImpl;
import org.apache.tapestry5.ioc.internal.DecoratorDefImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.ServiceBinderImpl;
import org.apache.tapestry5.ioc.internal.ServiceBuilderMethodInvoker;
import org.apache.tapestry5.ioc.internal.ServiceDefAccumulator;
import org.apache.tapestry5.ioc.internal.ServiceDefImpl;
import org.apache.tapestry5.ioc.internal.StartupDefImpl;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.slf4j.Logger;

public class DefaultModuleDefImpl
implements ModuleDef2,
ServiceDefAccumulator {
    private static final String BUILD_METHOD_NAME_PREFIX = "build";
    private static final String DECORATE_METHOD_NAME_PREFIX = "decorate";
    private static final String CONTRIBUTE_METHOD_NAME_PREFIX = "contribute";
    private static final String ADVISE_METHOD_NAME_PREFIX = "advise";
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();
    private final Class moduleClass;
    private final Logger logger;
    private final PlasticProxyFactory proxyFactory;
    private final Map<String, ServiceDef> serviceDefs = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, DecoratorDef> decoratorDefs = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, AdvisorDef> advisorDefs = CollectionFactory.newCaseInsensitiveMap();
    private final Set<ContributionDef> contributionDefs = CollectionFactory.newSet();
    private final Set<Class> defaultMarkers = CollectionFactory.newSet();
    private final Set<StartupDef> startups = CollectionFactory.newSet();
    private static final Set<Method> OBJECT_METHODS = CollectionFactory.newSet((Object[])Object.class.getMethods());

    public DefaultModuleDefImpl(Class<?> moduleClass, Logger logger, PlasticProxyFactory proxyFactory) {
        Set methods;
        this.moduleClass = moduleClass;
        this.logger = logger;
        this.proxyFactory = proxyFactory;
        Marker annotation = moduleClass.getAnnotation(Marker.class);
        if (annotation != null) {
            InternalUtils.validateMarkerAnnotations(annotation.value());
            this.defaultMarkers.addAll(Arrays.asList(annotation.value()));
        }
        try {
            methods = CollectionFactory.newSet((Object[])moduleClass.getMethods());
        }
        catch (Exception e) {
            throw new TapestryException("Exception while processing module class " + moduleClass.getName() + ": " + e.getMessage(), (Throwable)e);
        }
        Iterator methodIterator = methods.iterator();
        block2: while (methodIterator.hasNext()) {
            Method method = (Method)methodIterator.next();
            for (Method objectMethod : OBJECT_METHODS) {
                if (!DefaultModuleDefImpl.signaturesAreEqual(method, objectMethod)) continue;
                methodIterator.remove();
                continue block2;
            }
        }
        this.removeSyntheticMethods(methods);
        boolean modulePreventsServiceDecoration = moduleClass.getAnnotation(PreventServiceDecoration.class) != null;
        this.grind(methods, modulePreventsServiceDecoration);
        this.bind(methods, modulePreventsServiceDecoration);
        if (methods.isEmpty()) {
            return;
        }
        throw new RuntimeException(String.format("Module class %s contains unrecognized public methods: %s.", moduleClass.getName(), InternalUtils.joinSorted(methods)));
    }

    private static boolean signaturesAreEqual(Method m1, Method m2) {
        if (m1.getName() == m2.getName()) {
            Class<?>[] params2;
            if (!m1.getReturnType().equals(m2.getReturnType())) {
                return false;
            }
            Class<?>[] params1 = m1.getParameterTypes();
            if (params1.length == (params2 = m2.getParameterTypes()).length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("ModuleDef[%s %s]", this.moduleClass.getName(), InternalUtils.joinSorted(this.serviceDefs.keySet()));
    }

    @Override
    public Class getBuilderClass() {
        return this.moduleClass;
    }

    @Override
    public Set<String> getServiceIds() {
        return this.serviceDefs.keySet();
    }

    @Override
    public ServiceDef getServiceDef(String serviceId) {
        return this.serviceDefs.get(serviceId);
    }

    private void removeSyntheticMethods(Set<Method> methods) {
        Iterator<Method> iterator = methods.iterator();
        while (iterator.hasNext()) {
            Method m = iterator.next();
            if (!m.isSynthetic() && !m.getName().startsWith("$")) continue;
            iterator.remove();
        }
    }

    private void grind(Set<Method> remainingMethods, boolean modulePreventsServiceDecoration) {
        Method[] methods = this.moduleClass.getMethods();
        Comparator<Method> c = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int result = o1.getName().compareTo(o2.getName());
                if (result == 0) {
                    result = o2.getParameterTypes().length - o1.getParameterTypes().length;
                }
                return result;
            }
        };
        Arrays.sort(methods, c);
        for (Method m : methods) {
            String name = m.getName();
            if (name.startsWith(BUILD_METHOD_NAME_PREFIX)) {
                this.addServiceDef(m, modulePreventsServiceDecoration);
                remainingMethods.remove(m);
                continue;
            }
            if (name.startsWith(DECORATE_METHOD_NAME_PREFIX) || m.isAnnotationPresent(Decorate.class)) {
                this.addDecoratorDef(m);
                remainingMethods.remove(m);
                continue;
            }
            if (name.startsWith(CONTRIBUTE_METHOD_NAME_PREFIX) || m.isAnnotationPresent(Contribute.class)) {
                this.addContributionDef(m);
                remainingMethods.remove(m);
                continue;
            }
            if (name.startsWith(ADVISE_METHOD_NAME_PREFIX) || m.isAnnotationPresent(Advise.class)) {
                this.addAdvisorDef(m);
                remainingMethods.remove(m);
                continue;
            }
            if (!m.isAnnotationPresent(Startup.class)) continue;
            this.addStartupDef(m);
            remainingMethods.remove(m);
        }
    }

    private void addStartupDef(Method method) {
        this.startups.add(new StartupDefImpl(method));
    }

    private void addContributionDef(Method method) {
        Contribute annotation = method.getAnnotation(Contribute.class);
        Class serviceInterface = annotation == null ? null : annotation.value();
        String serviceId = annotation != null ? null : this.stripMethodPrefix(method, CONTRIBUTE_METHOD_NAME_PREFIX);
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            this.logger.warn(IOCMessages.contributionWrongReturnType(method));
        }
        ConfigurationType type = null;
        for (Class<?> parameterType : method.getParameterTypes()) {
            ConfigurationType thisParameter = PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(parameterType);
            if (thisParameter == null) continue;
            if (type != null) {
                throw new RuntimeException(IOCMessages.tooManyContributionParameters(method));
            }
            type = thisParameter;
        }
        if (type == null) {
            throw new RuntimeException(IOCMessages.noContributionParameter(method));
        }
        Set<Class> markers = this.extractMarkers(method, Contribute.class, Optional.class);
        boolean optional = method.getAnnotation(Optional.class) != null;
        ContributionDefImpl def = new ContributionDefImpl(serviceId, method, optional, this.proxyFactory, serviceInterface, markers);
        this.contributionDefs.add(def);
    }

    private void addDecoratorDef(Method method) {
        Decorate annotation = method.getAnnotation(Decorate.class);
        Class serviceInterface = annotation == null ? null : annotation.serviceInterface();
        String decoratorId = annotation == null ? this.stripMethodPrefix(method, DECORATE_METHOD_NAME_PREFIX) : this.extractId(serviceInterface, annotation.id());
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive() || returnType.isArray()) {
            throw new RuntimeException(String.format("Method %s is named like a service decorator method, but the return type (%s) is not acceptable (try Object).", InternalUtils.asString(method), method.getReturnType().getCanonicalName()));
        }
        Set<Class> markers = this.extractMarkers(method, Decorate.class);
        DecoratorDefImpl def = new DecoratorDefImpl(method, this.extractPatterns(decoratorId, method), this.extractConstraints(method), this.proxyFactory, decoratorId, serviceInterface, markers);
        this.decoratorDefs.put(decoratorId, def);
    }

    private <T extends Annotation> String[] extractPatterns(String id, Method method) {
        Match match = method.getAnnotation(Match.class);
        if (match == null) {
            return new String[]{id};
        }
        return match.value();
    }

    private String[] extractConstraints(Method method) {
        Order order = method.getAnnotation(Order.class);
        if (order == null) {
            return null;
        }
        return order.value();
    }

    private void addAdvisorDef(Method method) {
        Advise annotation = method.getAnnotation(Advise.class);
        Class serviceInterface = annotation == null ? null : annotation.serviceInterface();
        String advisorId = annotation == null ? this.stripMethodPrefix(method, ADVISE_METHOD_NAME_PREFIX) : this.extractId(serviceInterface, annotation.id());
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            throw new RuntimeException(String.format("Advise method %s does not return void.", this.toString(method)));
        }
        boolean found = false;
        for (Class<?> pt : method.getParameterTypes()) {
            if (!pt.equals(MethodAdviceReceiver.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException(String.format("Advise method %s must take a parameter of type %s.", this.toString(method), MethodAdviceReceiver.class.getName()));
        }
        Set<Class> markers = this.extractMarkers(method, Advise.class);
        AdvisorDefImpl def = new AdvisorDefImpl(method, this.extractPatterns(advisorId, method), this.extractConstraints(method), this.proxyFactory, advisorId, serviceInterface, markers);
        this.advisorDefs.put(advisorId, def);
    }

    private String extractId(Class serviceInterface, String id) {
        return InternalUtils.isBlank(id) ? serviceInterface.getSimpleName() : id;
    }

    private String toString(Method method) {
        return InternalUtils.asString(method, this.proxyFactory);
    }

    private String stripMethodPrefix(Method method, String prefix) {
        return method.getName().substring(prefix.length());
    }

    private void addServiceDef(final Method method, boolean modulePreventsServiceDecoration) {
        Class<?> returnType;
        String serviceId = InternalUtils.getServiceId(method);
        if (serviceId == null) {
            serviceId = this.stripMethodPrefix(method, BUILD_METHOD_NAME_PREFIX);
        }
        if (serviceId.equals("")) {
            serviceId = method.getReturnType().getSimpleName();
        }
        if ((returnType = method.getReturnType()).isPrimitive() || returnType.isArray()) {
            throw new RuntimeException(String.format("Method %s is named like a service builder method, but the return type (%s) is not acceptable (try an interface).", InternalUtils.asString(method), method.getReturnType().getCanonicalName()));
        }
        String scope = this.extractServiceScope(method);
        boolean eagerLoad = method.isAnnotationPresent(EagerLoad.class);
        boolean preventDecoration = modulePreventsServiceDecoration || method.getAnnotation(PreventServiceDecoration.class) != null;
        ObjectCreatorSource source = new ObjectCreatorSource(){

            @Override
            public ObjectCreator constructCreator(ServiceBuilderResources resources) {
                return new ServiceBuilderMethodInvoker(resources, this.getDescription(), method);
            }

            @Override
            public String getDescription() {
                return DefaultModuleDefImpl.this.toString(method);
            }
        };
        Set markers = CollectionFactory.newSet(this.defaultMarkers);
        markers.addAll(this.extractServiceDefMarkers(method));
        ServiceDefImpl serviceDef = new ServiceDefImpl(returnType, null, serviceId, markers, scope, eagerLoad, preventDecoration, source);
        this.addServiceDef(serviceDef);
    }

    private Collection<Class> extractServiceDefMarkers(Method method) {
        Marker annotation = method.getAnnotation(Marker.class);
        if (annotation == null) {
            return Collections.emptyList();
        }
        return CollectionFactory.newList((Object[])annotation.value());
    }

    private Set<Class> extractMarkers(Method method, final Class ... annotationClassesToSkip) {
        return ((Flow)F.flow((Object[])method.getAnnotations()).map((Mapper)new Mapper<Annotation, Class>(){

            public Class map(Annotation value) {
                return value.annotationType();
            }
        }).filter((Predicate)new Predicate<Class>(){

            public boolean accept(Class element) {
                for (Class skip : annotationClassesToSkip) {
                    if (!skip.equals(element)) continue;
                    return false;
                }
                return true;
            }
        })).toSet();
    }

    @Override
    public void addServiceDef(ServiceDef serviceDef) {
        String serviceId = serviceDef.getServiceId();
        ServiceDef existing = this.serviceDefs.get(serviceId);
        if (existing != null) {
            throw new RuntimeException(IOCMessages.buildMethodConflict(serviceId, serviceDef.toString(), existing.toString()));
        }
        this.serviceDefs.put(serviceId, serviceDef);
    }

    private String extractServiceScope(Method method) {
        Scope scope = method.getAnnotation(Scope.class);
        return scope != null ? scope.value() : "singleton";
    }

    @Override
    public Set<DecoratorDef> getDecoratorDefs() {
        return this.toSet(this.decoratorDefs);
    }

    @Override
    public Set<ContributionDef> getContributionDefs() {
        return this.contributionDefs;
    }

    @Override
    public String getLoggerName() {
        return this.moduleClass.getName();
    }

    private void bind(Set<Method> remainingMethods, boolean modulePreventsServiceDecoration) {
        Throwable failure;
        Method bindMethod = null;
        try {
            bindMethod = this.moduleClass.getMethod("bind", ServiceBinder.class);
            if (!Modifier.isStatic(bindMethod.getModifiers())) {
                throw new RuntimeException(IOCMessages.bindMethodMustBeStatic(this.toString(bindMethod)));
            }
            ServiceBinderImpl binder = new ServiceBinderImpl(this, bindMethod, this.proxyFactory, this.defaultMarkers, modulePreventsServiceDecoration);
            bindMethod.invoke(null, binder);
            binder.finish();
            remainingMethods.remove(bindMethod);
            return;
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        catch (IllegalArgumentException ex) {
            failure = ex;
        }
        catch (IllegalAccessException ex) {
            failure = ex;
        }
        catch (InvocationTargetException ex) {
            failure = ex.getTargetException();
        }
        String methodId = this.toString(bindMethod);
        throw new RuntimeException(IOCMessages.errorInBindMethod(methodId, failure), failure);
    }

    @Override
    public Set<AdvisorDef> getAdvisorDefs() {
        return this.toSet(this.advisorDefs);
    }

    private <K, V> Set<V> toSet(Map<K, V> map) {
        return CollectionFactory.newSet(map.values());
    }

    @Override
    public Set<StartupDef> getStartups() {
        return this.startups;
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Configuration.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(OrderedConfiguration.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(MappedConfiguration.class, ConfigurationType.MAPPED);
    }
}

