/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.ChecksumPath;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.ClasspathAssetProtectionRule;
import org.apache.tapestry5.services.assets.AssetRequestHandler;

public class ClasspathAssetRequestHandler
implements AssetRequestHandler {
    private final ResourceStreamer streamer;
    private final AssetSource assetSource;
    private final String baseFolder;
    private final ClasspathAssetProtectionRule classpathAssetProtectionRule;

    public ClasspathAssetRequestHandler(ResourceStreamer streamer, AssetSource assetSource, String baseFolder, ClasspathAssetProtectionRule classpathAssetProtectionRule) {
        this.streamer = streamer;
        this.assetSource = assetSource;
        this.baseFolder = baseFolder;
        this.classpathAssetProtectionRule = classpathAssetProtectionRule;
    }

    @Override
    public boolean handleAssetRequest(Request request, Response response, String extraPath) throws IOException {
        boolean handled;
        ChecksumPath path = new ChecksumPath(this.streamer, this.baseFolder, extraPath);
        if (this.classpathAssetProtectionRule.block(path.resourcePath)) {
            handled = false;
        } else {
            Resource resource = this.assetSource.resourceForPath(path.resourcePath);
            handled = path.stream(resource);
        }
        return handled;
    }
}

