/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.internal.util.LockSupport;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.StrategyRegistry;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.UrlAsset;
import org.apache.tapestry5.internal.services.UrlResource;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetNotFoundException;
import org.apache.tapestry5.services.AssetSource;
import org.slf4j.Logger;

public class AssetSourceImpl
extends LockSupport
implements AssetSource {
    private final List<String> EXTERNAL_URL_PREFIXES = Arrays.asList("http", "https", "//", "ftp");
    private final StrategyRegistry<AssetFactory> registry;
    private final ThreadLocale threadLocale;
    private final Map<String, Resource> prefixToRootResource = CollectionFactory.newMap();
    private final Map<Resource, SoftReference<Asset>> cache = CollectionFactory.newConcurrentMap();
    private final SymbolSource symbolSource;
    private final Logger logger;
    private final AtomicBoolean firstWarning = new AtomicBoolean(true);
    private final OperationTracker tracker;
    private final Request request;
    private final Map<String, AssetFactory> configuration;

    public AssetSourceImpl(ThreadLocale threadLocale, Map<String, AssetFactory> configuration, SymbolSource symbolSource, Logger logger, OperationTracker tracker) {
        this(threadLocale, configuration, symbolSource, logger, tracker, null);
    }

    public AssetSourceImpl(ThreadLocale threadLocale, Map<String, AssetFactory> configuration, SymbolSource symbolSource, Logger logger, OperationTracker tracker, Request request) {
        this.configuration = configuration;
        this.threadLocale = threadLocale;
        this.symbolSource = symbolSource;
        this.logger = logger;
        this.tracker = tracker;
        this.request = request;
        Map byResourceClass = CollectionFactory.newMap();
        for (Map.Entry<String, AssetFactory> e : configuration.entrySet()) {
            String prefix = e.getKey();
            AssetFactory factory = e.getValue();
            Resource rootResource = factory.getRootResource();
            byResourceClass.put(rootResource.getClass(), factory);
            this.prefixToRootResource.put(prefix, rootResource);
        }
        this.registry = StrategyRegistry.newInstance(AssetFactory.class, (Map)byResourceClass);
    }

    @PostInjection
    public void clearCacheWhenResourcesChange(ResourceChangeTracker tracker) {
        tracker.clearOnInvalidation(this.cache);
    }

    @Override
    public Asset getClasspathAsset(String path) {
        return this.getClasspathAsset(path, null);
    }

    @Override
    public Asset getClasspathAsset(String path, Locale locale) {
        return this.getAsset(null, path, locale);
    }

    @Override
    public Asset getContextAsset(String path, Locale locale) {
        return this.getAsset(this.prefixToRootResource.get("context"), path, locale);
    }

    @Override
    public Asset getAsset(Resource baseResource, String path, Locale locale) {
        return this.getAssetInLocale(baseResource, path, this.defaulted(locale));
    }

    @Override
    public Resource resourceForPath(String path) {
        return this.findResource(null, path);
    }

    @Override
    public Asset getExpandedAsset(String path) {
        return this.getUnlocalizedAsset(this.symbolSource.expandSymbols(path));
    }

    @Override
    public Asset getComponentAsset(final ComponentResources resources, final String path, final String libraryName) {
        assert (resources != null);
        assert (InternalUtils.isNonBlank((String)path));
        return (Asset)this.tracker.invoke(String.format("Resolving '%s' for component %s", path, resources.getCompleteId()), (Invokable)new Invokable<Asset>(){

            public Asset invoke() {
                String expanded = AssetSourceImpl.this.symbolSource.expandSymbols(path);
                int dotx = expanded.indexOf(58);
                if (expanded.startsWith("//") || dotx > 0 && !expanded.substring(0, dotx).equalsIgnoreCase("classpath")) {
                    String prefix;
                    String string = prefix = dotx >= 0 ? expanded.substring(0, dotx) : "//";
                    if (AssetSourceImpl.this.EXTERNAL_URL_PREFIXES.contains(prefix)) {
                        String url;
                        if (prefix.equals("//")) {
                            url = (AssetSourceImpl.this.request != null && AssetSourceImpl.this.request.isSecure() ? "https:" : "http:") + expanded;
                            url = url.replace("//:", "//");
                        } else {
                            url = expanded;
                        }
                        try {
                            UrlResource resource = new UrlResource(new URL(url));
                            return new UrlAsset(url, resource);
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return AssetSourceImpl.this.getAssetInLocale(resources.getBaseResource(), expanded, resources.getLocale());
                }
                String restOfPath = expanded.substring(dotx + 1);
                String metaRoot = "META-INF/assets/" + AssetSourceImpl.this.toPathPrefix(libraryName);
                String trimmedRestOfPath = restOfPath.startsWith("/") ? restOfPath.substring(1) : restOfPath;
                String metaPath = trimmedRestOfPath.startsWith("META-INF/assets/") ? trimmedRestOfPath : metaRoot + trimmedRestOfPath;
                Resource metaResource = AssetSourceImpl.this.findLocalizedResource(null, metaPath, resources.getLocale());
                Asset result = AssetSourceImpl.this.getComponentAsset(resources, expanded, metaResource);
                if (result == null) {
                    throw new RuntimeException(String.format("Unable to locate asset '%s' for component %s. It should be located at %s.", path, resources.getCompleteId(), metaPath));
                }
                Resource resultResource = result.getResource();
                if (!resultResource.equals(metaResource)) {
                    if (AssetSourceImpl.this.firstWarning.getAndSet(false)) {
                        AssetSourceImpl.this.logger.error("Packaging of classpath assets has changed in release 5.4; Assets should no longer be on the main classpath, but should be moved to 'META-INF/assets/' or a sub-folder. Future releases of Tapestry may no longer support assets on the main classpath.");
                    }
                    if (metaResource.getFolder().startsWith(metaRoot)) {
                        AssetSourceImpl.this.logger.warn(String.format("Classpath asset '/%s' should be moved to folder '/%s/'.", resultResource.getPath(), metaResource.getFolder()));
                    } else {
                        AssetSourceImpl.this.logger.warn(String.format("Classpath asset '/%s' should be moved under folder '/%s', and the relative path adjusted.", resultResource.getPath(), metaRoot));
                    }
                }
                return result;
            }
        });
    }

    private Asset getComponentAsset(ComponentResources resources, String expandedPath, Resource metaResource) {
        if (expandedPath.contains(":") || expandedPath.startsWith("/")) {
            return this.getAssetInLocale(resources.getBaseResource(), expandedPath, resources.getLocale());
        }
        if (metaResource.exists()) {
            return this.getAssetForResource(metaResource);
        }
        Resource oldStyle = this.findLocalizedResource(resources.getBaseResource(), expandedPath, resources.getLocale());
        if (oldStyle == null || !oldStyle.exists()) {
            return null;
        }
        return this.getAssetForResource(oldStyle);
    }

    private String toPathPrefix(String libraryName) {
        return libraryName.equals("") ? "" : libraryName + "/";
    }

    @Override
    public Asset getUnlocalizedAsset(String path) {
        return this.getAssetInLocale(null, path, null);
    }

    private Asset getAssetInLocale(Resource baseResource, String path, Locale locale) {
        return this.getLocalizedAssetFromResource(this.findResource(baseResource, path), locale);
    }

    private Resource findResource(Resource baseResource, String path) {
        assert (path != null);
        int colonx = path.indexOf(58);
        if (colonx < 0) {
            Resource root = baseResource != null ? baseResource : this.prefixToRootResource.get("classpath");
            return root.forFile(path);
        }
        String prefix = path.substring(0, colonx);
        Resource root = this.prefixToRootResource.get(prefix);
        if (root == null) {
            throw new IllegalArgumentException(String.format("Unknown prefix for asset path '%s'.", path));
        }
        return root.forFile(path.substring(colonx + 1));
    }

    private Resource findLocalizedResource(Resource baseResource, String path, Locale locale) {
        Resource unlocalized = this.findResource(baseResource, path);
        if (locale == null || !unlocalized.exists()) {
            return unlocalized;
        }
        return this.localize(unlocalized, locale);
    }

    private Resource localize(Resource unlocalized, Locale locale) {
        Resource localized = unlocalized.forLocale(locale);
        return localized != null ? localized : unlocalized;
    }

    private Asset getLocalizedAssetFromResource(Resource unlocalized, Locale locale) {
        Resource localized;
        if (locale == null) {
            localized = unlocalized;
        } else {
            Asset asset;
            Reference reference = this.cache.get(unlocalized);
            if (reference != null && (asset = (Asset)reference.get()) != null) {
                unlocalized = asset.getResource();
            }
            localized = unlocalized.forLocale(locale);
        }
        if (localized == null || !localized.exists()) {
            throw new AssetNotFoundException(String.format("Unable to locate asset '%s' (the file does not exist).", unlocalized), unlocalized);
        }
        return this.getAssetForResource(localized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asset getAssetForResource(Resource resource) {
        try {
            this.acquireReadLock();
            Asset result = TapestryInternalUtils.getAndDeref(this.cache, resource);
            if (result == null) {
                result = this.createAssetFromResource(resource);
                this.cache.put(resource, new SoftReference<Asset>(result));
            }
            Asset asset = result;
            return asset;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private Locale defaulted(Locale locale) {
        return locale != null ? locale : this.threadLocale.getLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asset createAssetFromResource(Resource resource) {
        try {
            this.upgradeReadLockToWriteLock();
            Asset result = TapestryInternalUtils.getAndDeref(this.cache, resource);
            if (result != null) {
                Asset asset = result;
                return asset;
            }
            Class<?> resourceClass = resource.getClass();
            AssetFactory factory = (AssetFactory)this.registry.get(resourceClass);
            Asset asset = factory.createAsset(resource);
            return asset;
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }
}

