/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.beanmodel.BeanModel;
import org.apache.tapestry5.beanmodel.BeanModelUtils;
import org.apache.tapestry5.beanmodel.PropertyModel;
import org.apache.tapestry5.beanmodel.services.BeanModelSource;
import org.apache.tapestry5.corelib.components.Any;
import org.apache.tapestry5.corelib.components.Delegate;
import org.apache.tapestry5.corelib.components.GridColumns;
import org.apache.tapestry5.corelib.components.GridPager;
import org.apache.tapestry5.corelib.components.GridRows;
import org.apache.tapestry5.corelib.data.GridPagerPosition;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridModel;
import org.apache.tapestry5.grid.GridPaginationModel;
import org.apache.tapestry5.grid.GridPaginationModelImpl;
import org.apache.tapestry5.grid.GridSortModel;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.bindings.AbstractBinding;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Grid
implements GridModel,
ClientElement {
    @Parameter(required=true, autoconnect=true)
    private GridDataSource source;
    private GridDataSource cachingSource;
    @Parameter(value="symbol:tapestry.components.grid_rows_per_page")
    private int rowsPerPage;
    @Parameter(value="symbol:tapestry.components.grid_pager_position", defaultPrefix="literal")
    private GridPagerPosition pagerPosition;
    @Parameter(principal=true)
    private Object row;
    @Parameter
    private int columnIndex;
    @Parameter
    private BeanModel model;
    private BeanModel dataModel;
    @Parameter
    private GridSortModel sortModel;
    @Parameter(defaultPrefix="literal")
    private String add;
    @Parameter(defaultPrefix="literal")
    private String include;
    @Parameter(defaultPrefix="literal")
    private String exclude;
    @Parameter(defaultPrefix="literal")
    private String reorder;
    @Parameter(value="block:empty", defaultPrefix="literal")
    @Property(write=false)
    private Block empty;
    @Parameter(name="class", defaultPrefix="literal", value="symbol:tapestry.components.grid_table_css_class")
    @Property(write=false)
    private String tableClass;
    @Parameter
    private boolean inPlace;
    @Parameter
    private boolean renderTableIfEmpty = false;
    @Property(write=false)
    private String zone;
    private boolean didRenderZoneDiv;
    @Parameter(value="defaultPaginationModel")
    private GridPaginationModel paginationModel;
    @Persist
    private GridPaginationModel defaultPaginationModel;
    @Inject
    private ComponentResources resources;
    @Inject
    private BeanModelSource modelSource;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Component(parameters={"index=inherit:columnIndex", "lean=inherit:lean", "overrides=overrides", "zone=zone"})
    private GridColumns columns;
    @Component(parameters={"columnIndex=inherit:columnIndex", "rowsPerPage=rowsPerPage", "currentPage=currentPage", "row=row", "overrides=overrides"}, publishParameters="rowIndex,rowClass,volatile,encoder,lean")
    private GridRows rows;
    @Component(parameters={"source=dataSource", "rowsPerPage=rowsPerPage", "currentPage=currentPage", "zone=zone"})
    private GridPager pager;
    @Component(parameters={"to=pagerTop"})
    private Delegate pagerTop;
    @Component(parameters={"to=pagerBottom"})
    private Delegate pagerBottom;
    @Component(parameters={"class=tableClass"}, inheritInformalParameters=true)
    private Any table;
    @Environmental(value=false)
    private FormSupport formSupport;
    @Parameter(value="this", allowNull=false)
    @Property(write=false)
    private PropertyOverrides overrides;
    @Environmental
    private ComponentEventResultProcessor componentEventResultProcessor;
    @Inject
    private ComponentDefaultProvider defaultsProvider;
    static final ComponentAction<Grid> SETUP_DATA_SOURCE = new ComponentAction<Grid>(){
        private static final long serialVersionUID = 8545187927995722789L;

        @Override
        public void execute(Grid component) {
            component.setupDataSource();
        }

        public String toString() {
            return "Grid.SetupDataSource";
        }
    };

    ValueEncoder defaultEncoder() {
        return this.defaultsProvider.defaultValueEncoder("row", this.resources);
    }

    GridSortModel defaultSortModel() {
        return new DefaultGridSortModel();
    }

    protected Binding defaultModel() {
        return new AbstractBinding(){

            @Override
            public Object get() {
                GridDataSource gridDataSource = Grid.this.source;
                Class rowType = gridDataSource.getRowType();
                if (Grid.this.renderTableIfEmpty || rowType == null) {
                    throw new RuntimeException(String.format("Unable to determine the bean type for rows from %s. You should bind the model parameter explicitly.", gridDataSource));
                }
                return Grid.this.modelSource.createDisplayModel(rowType, Grid.this.overrides.getOverrideMessages());
            }

            @Override
            public boolean isInvariant() {
                return false;
            }
        };
    }

    Object setupRender() {
        if (this.formSupport != null) {
            this.formSupport.store(this, SETUP_DATA_SOURCE);
        }
        this.setupDataSource();
        return !this.renderTableIfEmpty && this.cachingSource.isEmpty() ? this.empty : null;
    }

    void cleanupRender() {
        this.zone = null;
        this.dataModel = null;
    }

    public GridPaginationModel getDefaultPaginationModel() {
        if (this.defaultPaginationModel == null) {
            this.defaultPaginationModel = new GridPaginationModelImpl();
        }
        return this.defaultPaginationModel;
    }

    void setupDataSource() {
        int availableRowsWithLimit;
        int effectiveCurrentPage = this.getCurrentPage();
        int numberOfRowsRequiredToShowCurrentPage = 1 + (effectiveCurrentPage - 1) * this.rowsPerPage;
        int numberOfRowsRequiredToFillCurrentPage = effectiveCurrentPage * this.rowsPerPage;
        this.cachingSource = new CachingDataSource(this.source);
        if (this.pagerPosition != GridPagerPosition.NONE) {
            this.cachingSource.getAvailableRows();
        }
        if ((availableRowsWithLimit = this.cachingSource.getAvailableRows(numberOfRowsRequiredToFillCurrentPage)) == 0) {
            return;
        }
        if (numberOfRowsRequiredToShowCurrentPage > availableRowsWithLimit) {
            int maxPage;
            effectiveCurrentPage = maxPage = (availableRowsWithLimit - 1) / this.rowsPerPage + 1;
        }
        int startIndex = (effectiveCurrentPage - 1) * this.rowsPerPage;
        int endIndex = Math.min(startIndex + this.rowsPerPage - 1, availableRowsWithLimit - 1);
        this.cachingSource.prepare(startIndex, endIndex, this.sortModel.getSortConstraints());
    }

    Object beginRender(MarkupWriter writer) {
        if (this.cachingSource.isEmpty()) {
            return !this.renderTableIfEmpty ? Boolean.valueOf(false) : null;
        }
        if (this.inPlace && this.zone == null) {
            this.javaScriptSupport.require("t5/core/zone");
            writer.element("div", "data-container-type", "zone");
            this.didRenderZoneDiv = true;
            this.zone = "^";
        }
        return null;
    }

    void afterRender(MarkupWriter writer) {
        if (this.didRenderZoneDiv) {
            writer.end();
            this.didRenderZoneDiv = false;
        }
    }

    @Override
    public BeanModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = this.model;
            BeanModelUtils.modify((BeanModel)this.dataModel, (String)this.add, (String)this.include, (String)this.exclude, (String)this.reorder);
        }
        return this.dataModel;
    }

    public int getNumberOfProperties() {
        return this.getDataModel().getPropertyNames().size();
    }

    @Override
    public GridDataSource getDataSource() {
        return this.cachingSource;
    }

    @Override
    public GridSortModel getSortModel() {
        return this.sortModel;
    }

    public Object getPagerTop() {
        return this.pagerPosition.isMatchTop() ? this.pager : null;
    }

    public Object getPagerBottom() {
        return this.pagerPosition.isMatchBottom() ? this.pager : null;
    }

    public int getCurrentPage() {
        Integer currentPage = this.paginationModel.getCurrentPage();
        return currentPage == null ? 1 : currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.paginationModel.setCurrentPage(currentPage);
    }

    private boolean getSortAscending() {
        Boolean sortAscending = this.paginationModel.getSortAscending();
        return sortAscending != null && sortAscending != false;
    }

    private void setSortAscending(boolean sortAscending) {
        this.paginationModel.setSortAscending(sortAscending);
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public void reset() {
        this.sortModel.clear();
        this.setCurrentPage(1);
    }

    void onInPlaceUpdate() throws IOException {
        this.zone = "^";
        this.componentEventResultProcessor.processResultValue(this);
    }

    @Override
    public String getClientId() {
        return this.table.getClientId();
    }

    class DefaultGridSortModel
    implements GridSortModel {
        DefaultGridSortModel() {
        }

        @Override
        public ColumnSort getColumnSort(String columnId) {
            if (Grid.this.paginationModel == null || !TapestryInternalUtils.isEqual(columnId, Grid.this.paginationModel.getSortColumnId())) {
                return ColumnSort.UNSORTED;
            }
            return this.getColumnSort();
        }

        private ColumnSort getColumnSort() {
            return Grid.this.getSortAscending() ? ColumnSort.ASCENDING : ColumnSort.DESCENDING;
        }

        @Override
        public void updateSort(String columnId) {
            assert (InternalUtils.isNonBlank((String)columnId));
            if (columnId.equals(Grid.this.paginationModel.getSortColumnId())) {
                Grid.this.setSortAscending(!Grid.this.getSortAscending());
                return;
            }
            Grid.this.paginationModel.setSortColumnId(columnId);
            Grid.this.setSortAscending(true);
        }

        @Override
        public List<SortConstraint> getSortConstraints() {
            if (Grid.this.paginationModel == null || Grid.this.paginationModel.getSortColumnId() == null) {
                return Collections.emptyList();
            }
            PropertyModel sortModel = Grid.this.getDataModel().getById(Grid.this.paginationModel.getSortColumnId());
            SortConstraint constraint = new SortConstraint(sortModel, this.getColumnSort());
            return Collections.singletonList(constraint);
        }

        @Override
        public void clear() {
            Grid.this.paginationModel.setSortColumnId(null);
            Grid.this.paginationModel.setSortAscending(null);
        }
    }

    static class CachingDataSource
    implements GridDataSource {
        private final GridDataSource delegate;
        private boolean availableRowsCached;
        private int availableRows;
        private boolean emptyCached;
        private boolean empty;

        CachingDataSource(GridDataSource delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEmpty() {
            if (!this.emptyCached) {
                this.empty = this.delegate.isEmpty();
                this.emptyCached = true;
                if (this.empty) {
                    this.availableRows = 0;
                    this.availableRowsCached = true;
                }
            }
            return this.empty;
        }

        @Override
        public int getAvailableRows(int limit) {
            if (!this.availableRowsCached) {
                int result = this.delegate.getAvailableRows(limit);
                if (result == 0) {
                    this.empty = true;
                    this.emptyCached = true;
                } else {
                    this.empty = false;
                    this.emptyCached = true;
                }
                if (result < limit) {
                    this.availableRows = result;
                    this.availableRowsCached = true;
                }
                return result;
            }
            return Math.min(this.availableRows, limit);
        }

        @Override
        public int getAvailableRows() {
            if (!this.availableRowsCached) {
                this.availableRows = this.delegate.getAvailableRows();
                this.availableRowsCached = true;
                if (this.availableRows == 0) {
                    this.empty = true;
                    this.emptyCached = true;
                } else {
                    this.empty = false;
                    this.emptyCached = true;
                }
            }
            return this.availableRows;
        }

        @Override
        public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
            this.delegate.prepare(startIndex, endIndex, sortConstraints);
        }

        @Override
        public Object getRowValue(int index) {
            return this.delegate.getRowValue(index);
        }

        @Override
        public Class getRowType() {
            return this.delegate.getRowType();
        }
    }
}

