/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.internal.services;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.upload.internal.services.ParameterValue;

public class ParametersServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, ParameterValue> parameters = CollectionFactory.newMap();

    public ParametersServletRequestWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public String getParameter(String name) {
        return this.getValueFor(name).single();
    }

    public Map<String, String[]> getParameterMap() {
        Map paramMap = CollectionFactory.newMap();
        for (Map.Entry<String, ParameterValue> e : this.parameters.entrySet()) {
            ParameterValue value = e.getValue();
            paramMap.put(e.getKey(), value.multi());
        }
        return paramMap;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getValueFor(name).multi();
    }

    public void addParameter(String name, String value) {
        ParameterValue pv = this.parameters.get(name);
        if (pv == null) {
            pv = new ParameterValue(value);
            this.parameters.put(name, pv);
        } else {
            pv.add(value);
        }
    }

    ParameterValue getValueFor(String name) {
        ParameterValue value = this.parameters.get(name);
        return value == null ? ParameterValue.NULL : value;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
    }
}

