/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.LockSupport;
import org.apache.tapestry5.ioc.util.LocalizedNameGenerator;

public abstract class AbstractResource
extends LockSupport
implements Resource {
    private final String path;
    private boolean exists;
    private boolean existsComputed;
    private Localization firstLocalization;

    protected AbstractResource(String path) {
        assert (path != null);
        this.path = path.startsWith("/") ? path.substring(1) : path;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getFile() {
        return AbstractResource.extractFile(this.path);
    }

    private static String extractFile(String path) {
        int slashx = path.lastIndexOf(47);
        return path.substring(slashx + 1);
    }

    public final String getFolder() {
        int slashx = this.path.lastIndexOf(47);
        return slashx < 0 ? "" : this.path.substring(0, slashx);
    }

    public final Resource forFile(String relativePath) {
        assert (relativePath != null);
        List terms = CollectionFactory.newList();
        for (String term : this.getFolder().split("/")) {
            terms.add(term);
        }
        relativePath = relativePath.replace('\\', '/');
        for (String term : relativePath.split("/")) {
            if (term.equals("") || term.equals(".")) continue;
            if (term.equals("..")) {
                if (terms.isEmpty()) {
                    throw new IllegalStateException(String.format("Relative path '%s' for %s would go above root.", new Object[]{relativePath, this}));
                }
                terms.remove(terms.size() - 1);
                continue;
            }
            terms.add(term);
        }
        StringBuilder path = new StringBuilder(100);
        String sep = "";
        for (String term : terms) {
            path.append(sep).append(term);
            sep = "/";
        }
        return this.createResource(path.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Resource forLocale(Locale locale) {
        try {
            this.acquireReadLock();
            Localization l = this.firstLocalization;
            while (l != null) {
                if (l.locale.equals(locale)) {
                    Resource resource = l.resource;
                    return resource;
                }
                l = l.next;
            }
            Resource resource = this.populateLocalizationCache(locale);
            return resource;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource populateLocalizationCache(Locale locale) {
        try {
            this.upgradeReadLockToWriteLock();
            Localization l = this.firstLocalization;
            while (l != null) {
                if (l.locale.equals(locale)) {
                    Resource resource = l.resource;
                    return resource;
                }
                l = l.next;
            }
            Resource result = this.findLocalizedResource(locale);
            this.firstLocalization = new Localization(locale, result, this.firstLocalization);
            Resource resource = result;
            return resource;
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    private Resource findLocalizedResource(Locale locale) {
        for (String path : new LocalizedNameGenerator(this.path, locale)) {
            Resource potential = this.createResource(path);
            if (!potential.exists()) continue;
            return potential;
        }
        return null;
    }

    public final Resource withExtension(String extension) {
        assert (InternalUtils.isNonBlank(extension));
        int dotx = this.path.lastIndexOf(46);
        if (dotx < 0) {
            return this.createResource(this.path + "." + extension);
        }
        return this.createResource(this.path.substring(0, dotx + 1) + extension);
    }

    private Resource createResource(String path) {
        if (this.path.equals(path)) {
            return this;
        }
        return this.newResource(path);
    }

    public boolean exists() {
        try {
            this.acquireReadLock();
            if (!this.existsComputed) {
                this.computeExists();
            }
            boolean bl = this.exists;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void computeExists() {
        try {
            this.upgradeReadLockToWriteLock();
            if (!this.existsComputed) {
                this.exists = this.toURL() != null;
                this.existsComputed = true;
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    public InputStream openStream() throws IOException {
        URL url = this.toURL();
        if (url == null) {
            return null;
        }
        if ("jar".equals(url.getProtocol())) {
            boolean isDirectory;
            String urlAsString = url.toString();
            int indexOfExclamationMark = urlAsString.indexOf(33);
            String resourceInJar = urlAsString.substring(indexOfExclamationMark + 2);
            URL directoryResource = Thread.currentThread().getContextClassLoader().getResource(resourceInJar + "/");
            boolean bl = isDirectory = directoryResource != null && "jar".equals(directoryResource.getProtocol());
            if (isDirectory) {
                throw new IOException("Cannot open a stream for a resource that references a directory inside a JAR file (" + url + ").");
            }
        }
        return new BufferedInputStream(url.openStream());
    }

    protected abstract Resource newResource(String var1);

    protected void validateURL(URL url) {
        if (url == null) {
            return;
        }
        if (!url.getProtocol().equals("file")) {
            return;
        }
        File file = this.toFile(url);
        String expectedFileName = null;
        try {
            String sep = System.getProperty("file.separator");
            expectedFileName = AbstractResource.extractFile(file.getCanonicalPath().replace(sep, "/"));
        }
        catch (IOException e) {
            return;
        }
        String actualFileName = this.getFile();
        if (actualFileName.equals(expectedFileName)) {
            return;
        }
        throw new IllegalStateException(String.format("Resource %s does not match the case of the actual file name, '%s'.", new Object[]{this, expectedFileName}));
    }

    private File toFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    public boolean isVirtual() {
        return false;
    }

    private static class Localization {
        final Locale locale;
        final Resource resource;
        final Localization next;

        private Localization(Locale locale, Resource resource, Localization next) {
            this.locale = locale;
            this.resource = resource;
            this.next = next;
        }
    }
}

