/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.validator;

import java.util.regex.Pattern;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Html5Support;
import org.apache.tapestry5.services.javascript.DataConstants;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.validator.AbstractValidator;

public class Email
extends AbstractValidator<Void, String> {
    private static final Pattern PATTERN = Pattern.compile("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", 2);
    private final Html5Support html5Support;

    public Email(JavaScriptSupport javaScriptSupport, Html5Support html5Support) {
        super(null, String.class, "invalid-email", javaScriptSupport);
        this.html5Support = html5Support;
    }

    @Override
    public void render(Field field, Void constraintValue, MessageFormatter formatter, MarkupWriter writer, FormSupport formSupport) {
        if (formSupport.isClientValidationEnabled()) {
            this.javaScriptSupport.require("t5/core/validation");
            writer.attributes(DataConstants.VALIDATION_ATTRIBUTE, true, "data-validate-email", true, "data-email-message", formatter.toString());
        }
        if (this.html5Support.isHtml5SupportEnabled()) {
            writer.getElement().forceAttributes("type", "email");
        }
    }

    @Override
    public void validate(Field field, Void constraintValue, MessageFormatter formatter, String value) throws ValidationException {
        if (!PATTERN.matcher(value).matches()) {
            throw new ValidationException(formatter.toString());
        }
    }
}

