/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.annotations.ImmutableSessionPersistedObject;
import org.apache.tapestry5.internal.hibernate.SessionRestorable;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.hibernate.Session;

@ImmutableSessionPersistedObject
public class PersistedEntity
implements SessionRestorable {
    private static final long serialVersionUID = 897120520279686518L;
    private final String entityName;
    private final Serializable id;

    public PersistedEntity(String entityName, Serializable id) {
        assert (InternalUtils.isNonBlank((String)entityName));
        assert (id != null);
        this.entityName = entityName;
        this.id = id;
    }

    @Override
    public Object restoreWithSession(Session session) {
        try {
            return session.get(this.entityName, this.id);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load session-persisted entity %s(%s): %s", this.entityName, this.id, ex), ex);
        }
    }

    public String toString() {
        return String.format("<PersistedEntity: %s(%s)>", this.entityName, this.id);
    }
}

