/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.HeartbeatDeferred;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class Label {
    @Parameter(name="for", required=true, allowNull=false, defaultPrefix="component")
    private Field field;
    @Parameter(defaultPrefix="literal")
    private String clientId;
    @Environmental
    private ValidationDecorator decorator;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    @Symbol(value="tapestry.production-mode")
    private boolean productionMode;
    @Parameter
    private boolean ignoreBody;
    private Element labelElement;
    private String string;
    private String string2;

    boolean beginRender(MarkupWriter writer) {
        this.decorator.beforeLabel(this.field);
        this.labelElement = writer.element("label", "class", "control-label");
        this.resources.renderInformalParameters(writer);
        this.updateAttributes();
        return !this.ignoreBody;
    }

    @HeartbeatDeferred
    private void updateAttributes() {
        String fieldId = this.field.getClientId();
        if (!this.productionMode && fieldId == null) {
            String warningText = "The Label component " + this.resources.getCompleteId() + " is linked to a Field that failed to return a clientId. The 'for' attibute will not be rendered.";
            this.javaScriptSupport.require("t5/core/console").invoke("warn").with(warningText);
        }
        String id = this.clientId != null ? this.clientId : this.javaScriptSupport.allocateClientId(fieldId + "-label");
        this.labelElement.attribute("id", id);
        this.labelElement.forceAttributes("for", fieldId);
        Element input = this.labelElement.getDocument().getElementById(this.field.getClientId());
        if (input != null) {
            input.attribute("aria-labelledby", id);
        }
        this.decorator.insideLabel(this.field, this.labelElement);
    }

    void afterRender(MarkupWriter writer) {
        boolean bodyIsBlank = InternalUtils.isBlank((String)this.labelElement.getChildMarkup());
        if (bodyIsBlank) {
            writer.write(this.field.getLabel());
        }
        writer.end();
        this.decorator.afterLabel(this.field);
    }
}

