/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.ModuleManager;

public class ModuleDispatcher
implements Dispatcher {
    private final ModuleManager moduleManager;
    private final ResourceStreamer streamer;
    private final OperationTracker tracker;
    private final JavaScriptStackSource javaScriptStackSource;
    private final JavaScriptStackPathConstructor javaScriptStackPathConstructor;
    private final LocalizationSetter localizationSetter;
    private final String requestPrefix;
    private final String stackPathPrefix;
    private final boolean compress;
    private final Set<ResourceStreamer.Options> omitExpiration = EnumSet.of(ResourceStreamer.Options.OMIT_EXPIRATION);
    private Map<String, String> moduleNameToStackName;

    public ModuleDispatcher(ModuleManager moduleManager, ResourceStreamer streamer, OperationTracker tracker, PathConstructor pathConstructor, JavaScriptStackSource javaScriptStackSource, JavaScriptStackPathConstructor javaScriptStackPathConstructor, LocalizationSetter localizationSetter, String prefix, @Symbol(value="tapestry.asset-path-prefix") String assetPrefix, boolean compress) {
        this.moduleManager = moduleManager;
        this.streamer = streamer;
        this.tracker = tracker;
        this.javaScriptStackSource = javaScriptStackSource;
        this.javaScriptStackPathConstructor = javaScriptStackPathConstructor;
        this.localizationSetter = localizationSetter;
        this.compress = compress;
        this.requestPrefix = pathConstructor.constructDispatchPath(compress ? prefix + ".gz" : prefix) + "/";
        this.stackPathPrefix = pathConstructor.constructClientPath(assetPrefix, "stack") + "/";
    }

    @Override
    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (path.startsWith(this.requestPrefix)) {
            String extraPath = path.substring(this.requestPrefix.length());
            Locale locale = request.getLocale();
            if (!this.handleModuleRequest(locale, extraPath, response)) {
                response.sendError(404, String.format("No module for path '%s'.", extraPath));
            }
            return true;
        }
        return false;
    }

    private boolean handleModuleRequest(Locale locale, String extraPath, Response response) throws IOException {
        int dotx = extraPath.lastIndexOf(46);
        if (dotx < 0) {
            return false;
        }
        if (!extraPath.substring(dotx + 1).equals("js")) {
            return false;
        }
        final String moduleName = extraPath.substring(0, dotx);
        String stackName = this.findStackForModule(moduleName);
        if (stackName != null) {
            String firstUrl;
            this.localizationSetter.setNonPersistentLocaleFromLocaleName(locale.toString());
            List<String> libraryUrls = this.javaScriptStackPathConstructor.constructPathsForJavaScriptStack(stackName);
            if (libraryUrls.size() == 1 && (firstUrl = libraryUrls.get(0)).startsWith(this.stackPathPrefix)) {
                response.sendRedirect(firstUrl);
                return true;
            }
        }
        return (Boolean)this.tracker.perform(String.format("Streaming %s %s", this.compress ? "compressed module" : "module", moduleName), (IOOperation)new IOOperation<Boolean>(){

            public Boolean perform() throws IOException {
                Resource resource = ModuleDispatcher.this.moduleManager.findResourceForModule(moduleName);
                if (resource != null) {
                    return ModuleDispatcher.this.streamer.streamResource(resource, ModuleDispatcher.this.compress ? "z" : "", (Set<ResourceStreamer.Options>)ModuleDispatcher.this.omitExpiration);
                }
                return false;
            }
        });
    }

    private String findStackForModule(String moduleName) {
        return this.getModuleNameToStackName().get(moduleName);
    }

    private Map<String, String> getModuleNameToStackName() {
        if (this.moduleNameToStackName == null) {
            this.moduleNameToStackName = CollectionFactory.newMap();
            for (String stackName : this.javaScriptStackSource.getStackNames()) {
                for (String moduleName : this.javaScriptStackSource.getStack(stackName).getModules()) {
                    this.moduleNameToStackName.put(moduleName, stackName);
                }
            }
        }
        return this.moduleNameToStackName;
    }
}

