/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.pageload;

import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.pageload.PagePreloader;
import org.slf4j.Logger;

public class PagePreloaderImpl
implements PagePreloader {
    private final Logger logger;
    private final List<String> pageNames = CollectionFactory.newList();
    private final OperationTracker tracker;
    private final ComponentSource componentSource;
    private final ThreadLocale threadLocale;
    private final LocalizationSetter localizationSetter;

    public PagePreloaderImpl(Logger logger, OperationTracker tracker, ComponentSource componentSource, Collection<String> configuration, ThreadLocale threadLocale, LocalizationSetter localizationSetter) {
        this.tracker = tracker;
        this.componentSource = componentSource;
        this.logger = logger;
        this.threadLocale = threadLocale;
        this.localizationSetter = localizationSetter;
        this.pageNames.addAll(configuration);
    }

    @Override
    public void preloadPages() {
        if (this.pageNames.isEmpty()) {
            return;
        }
        this.logger.info(String.format("Preloading %,d pages.", this.pageNames.size()));
        this.threadLocale.setLocale(this.localizationSetter.getSupportedLocales().get(0));
        long startNanos = System.nanoTime();
        try {
            for (final String pageName : this.pageNames) {
                this.tracker.run(String.format("Preloading page '%s'.", pageName), new Runnable(){

                    @Override
                    public void run() {
                        PagePreloaderImpl.this.componentSource.getPage(pageName);
                    }
                });
            }
        }
        catch (Exception ex) {
            this.logger.error(ExceptionUtils.toMessage((Throwable)ex), (Throwable)ex);
            return;
        }
        double elapsedNanos = System.nanoTime() - startNanos;
        this.logger.info(String.format("Preloaded %,d pages in %.2f seconds.", this.pageNames.size(), elapsedNanos * 1.0E-9));
    }
}

