/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.pageload;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public final class ComponentResourceSelector {
    public final Locale locale;
    private final Map<Class, Object> axis;

    public ComponentResourceSelector(Locale locale) {
        this(locale, Collections.emptyMap());
    }

    private ComponentResourceSelector(Locale locale, Map<Class, Object> axis) {
        assert (locale != null);
        this.locale = locale;
        this.axis = axis;
    }

    public <T> ComponentResourceSelector withAxis(Class<T> axisType, T axisValue) {
        assert (axisType != null);
        assert (axisValue != null);
        if (this.axis.containsKey(axisType)) {
            throw new IllegalArgumentException(String.format("Axis type %s is already specified as %s.", axisType.getName(), this.axis.get(axisType)));
        }
        Map updated = CollectionFactory.newMap(this.axis);
        updated.put(axisType, axisValue);
        return new ComponentResourceSelector(this.locale, updated);
    }

    public <T> T getAxis(Class<T> axisType) {
        return axisType.cast(this.axis.get(axisType));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComponentResourceSelector)) {
            return false;
        }
        ComponentResourceSelector other = (ComponentResourceSelector)obj;
        return this.locale.equals(other.locale) && this.axis.equals(other.axis);
    }

    public int hashCode() {
        return 37 * this.locale.hashCode() + this.axis.hashCode();
    }

    public String toString() {
        return String.format("ComponentResourceSelector[%s]", this.toShortString());
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.locale.toString());
        String sep = " ";
        for (Map.Entry<Class, Object> e : this.axis.entrySet()) {
            builder.append(sep);
            builder.append(e.getKey().getName());
            builder.append('=');
            builder.append(e.getValue().toString());
            sep = ", ";
        }
        return builder.toString();
    }
}

