/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.tapestry5.internal.services.assets.CompressedStreamableResource;
import org.apache.tapestry5.internal.services.assets.DelegatingSRS;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class SRSCompressingInterceptor
extends DelegatingSRS {
    private final int compressionCutoff;
    private final AssetChecksumGenerator checksumGenerator;

    public SRSCompressingInterceptor(StreamableResourceSource delegate, int compressionCutoff, AssetChecksumGenerator checksumGenerator) {
        super(delegate);
        this.compressionCutoff = compressionCutoff;
        this.checksumGenerator = checksumGenerator;
    }

    @Override
    public StreamableResource getStreamableResource(Resource baseResource, StreamableResourceProcessing processing, ResourceDependencies dependencies) throws IOException {
        StreamableResource streamable = this.delegate.getStreamableResource(baseResource, processing, dependencies);
        return processing == StreamableResourceProcessing.COMPRESSION_ENABLED ? this.compress(streamable) : streamable;
    }

    private StreamableResource compress(StreamableResource uncompressed) throws IOException {
        if (uncompressed.getCompression() != CompressionStatus.COMPRESSABLE) {
            return uncompressed;
        }
        int size = uncompressed.getSize();
        if (size < this.compressionCutoff) {
            return uncompressed;
        }
        return new CompressedStreamableResource(uncompressed, this.checksumGenerator);
    }
}

