/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.internal.services;

import java.io.IOException;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.internal.services.ComponentResultProcessorWrapper;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventRequestFilter;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.Traditional;
import org.apache.tapestry5.upload.internal.services.UploadMessages;
import org.apache.tapestry5.upload.services.MultipartDecoder;

public class UploadExceptionFilter
implements ComponentEventRequestFilter {
    private final MultipartDecoder decoder;
    private final ComponentEventResultProcessor resultProcessor;
    private ComponentSource componentSource;

    public UploadExceptionFilter(MultipartDecoder decoder, @Traditional @Primary ComponentEventResultProcessor resultProcessor, ComponentSource componentSource) {
        this.decoder = decoder;
        this.resultProcessor = resultProcessor;
        this.componentSource = componentSource;
    }

    public void handle(ComponentEventRequestParameters parameters, ComponentEventRequestHandler handler) throws IOException {
        FileUploadException uploadException = this.decoder.getUploadException();
        if (uploadException != null) {
            Component page = this.componentSource.getPage(parameters.getActivePageName());
            ComponentResultProcessorWrapper callback = new ComponentResultProcessorWrapper(this.resultProcessor);
            page.getComponentResources().triggerEvent("uploadException", new Object[]{uploadException}, (ComponentEventCallback)callback);
            if (callback.isAborted()) {
                return;
            }
            throw new RuntimeException(UploadMessages.unableToDecode(), (Throwable)uploadException);
        }
        handler.handle(parameters);
    }
}

