/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tapestry5.internal.webresources.RhinoExecutor;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoExecutorPool {
    private final OperationTracker tracker;
    private final List<Resource> scripts;
    private final Queue<RhinoExecutor> executors = new ConcurrentLinkedQueue<RhinoExecutor>();
    private final ContextFactory contextFactory = new ContextFactory();

    public RhinoExecutorPool(OperationTracker tracker, List<Resource> scripts) {
        this.tracker = tracker;
        this.scripts = scripts;
    }

    public RhinoExecutor get() {
        RhinoExecutor executor = this.executors.poll();
        if (executor != null) {
            return executor;
        }
        return this.createExecutor();
    }

    private void put(RhinoExecutor executor) {
        this.executors.add(executor);
    }

    private RhinoExecutor createExecutor() {
        return (RhinoExecutor)this.tracker.invoke(String.format("Creating Rhino executor for source(s) %s.", InternalUtils.join(this.scripts)), (Invokable)new Invokable<RhinoExecutor>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RhinoExecutor invoke() {
                final Context context = RhinoExecutorPool.this.contextFactory.enterContext();
                final ScriptableObject scope = context.initStandardObjects();
                try {
                    context.setOptimizationLevel(-1);
                    for (Resource script : RhinoExecutorPool.this.scripts) {
                        RhinoExecutorPool.this.loadScript(context, scope, script);
                    }
                }
                finally {
                    Context.exit();
                }
                return new RhinoExecutor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ScriptableObject invokeFunction(String functionName, Object ... arguments) {
                        RhinoExecutorPool.this.contextFactory.enterContext(context);
                        try {
                            NativeFunction function = (NativeFunction)scope.get(functionName, (Scriptable)scope);
                            ScriptableObject scriptableObject = (ScriptableObject)function.call(context, (Scriptable)scope, null, arguments);
                            return scriptableObject;
                        }
                        finally {
                            Context.exit();
                        }
                    }

                    @Override
                    public void discard() {
                        RhinoExecutorPool.this.put(this);
                    }
                };
            }
        });
    }

    private void loadScript(final Context context, final ScriptableObject scope, final Resource script) {
        this.tracker.run(String.format("Loading script %s.", script), new Runnable(){

            @Override
            public void run() {
                InputStream in = null;
                InputStreamReader r = null;
                try {
                    in = script.openStream();
                    r = new InputStreamReader(in);
                    context.evaluateReader((Scriptable)scope, (Reader)r, script.toString(), 1, null);
                }
                catch (IOException ex) {
                    try {
                        throw new RuntimeException(String.format("Unable to read script %s: %s", script, ExceptionUtils.toMessage((Throwable)ex)), ex);
                    }
                    catch (Throwable throwable) {
                        InternalUtils.close(r);
                        InternalUtils.close((Closeable)in);
                        throw throwable;
                    }
                }
                InternalUtils.close((Closeable)r);
                InternalUtils.close((Closeable)in);
            }
        });
    }
}

