/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.annotations.CommitAfter;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;

public class CommitAfterMethodAdvice
implements MethodAdvice {
    private final EntityManagerManager manager;

    public CommitAfterMethodAdvice(EntityManagerManager manager) {
        this.manager = manager;
    }

    public void advise(MethodInvocation invocation) {
        if (invocation.hasAnnotation(CommitAfter.class)) {
            PersistenceContext annotation = (PersistenceContext)invocation.getAnnotation(PersistenceContext.class);
            EntityTransaction transaction = this.getTransaction(annotation);
            if (transaction != null && !transaction.isActive()) {
                transaction.begin();
            }
            try {
                invocation.proceed();
            }
            catch (RuntimeException e) {
                if (transaction != null && transaction.isActive()) {
                    this.rollbackTransaction(transaction);
                }
                throw e;
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
        } else {
            invocation.proceed();
        }
    }

    private void rollbackTransaction(EntityTransaction transaction) {
        try {
            transaction.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private EntityTransaction getTransaction(PersistenceContext annotation) {
        EntityManager em = JpaInternalUtils.getEntityManager(this.manager, annotation);
        if (em == null) {
            return null;
        }
        return em.getTransaction();
    }
}

