/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.tapestry5.internal.services.StringInterner;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.InvalidationEventHub;

public class StringInternerImpl
implements StringInterner {
    private final Map<String, String> cache = CollectionFactory.newConcurrentMap();

    @PostConstruct
    public void setupInvalidation(@ComponentClasses InvalidationEventHub hub) {
        hub.clearOnInvalidation(this.cache);
    }

    @Override
    public String intern(String string) {
        String result = this.cache.get(string);
        if (result == null) {
            this.cache.put(string, string);
            result = string;
        }
        return result;
    }

    @Override
    public String format(String format, Object ... arguments) {
        return this.intern(String.format(format, arguments));
    }
}

