/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.Arrays;
import java.util.List;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.tapestry5.internal.jpa.PersistenceUnitInfoImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.jpa.TapestryPersistenceUnitInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PersistenceContentHandler
implements ContentHandler {
    private static final List<String> NAMESPACE_URIS = Arrays.asList("http://java.sun.com/xml/ns/persistence", "http://xmlns.jcp.org/xml/ns/persistence");
    private static final String ELEMENT_PERSISTENCE_UNIT = "persistence-unit";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ELEMENT_JTA_DATA_SOURCE = "jta-data-source";
    private static final String ELEMENT_NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String ELEMENT_MAPPING_FILE = "mapping-file";
    private static final String ELEMENT_JAR_FILE = "jar-file";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String ELEMENT_CACHING = "shared-cache-mode";
    private static final String ELEMENT_VALIDATION_MODE = "validation-mode";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_VERSION = "value";
    private static final String ATTRIBUTE_TRANSACTION_TYPE = "transaction-type";
    private final List<TapestryPersistenceUnitInfo> persistenceUnits = CollectionFactory.newList();
    private PersistenceUnitInfoImpl persistenceUnitInfo;
    private StringBuilder characters;

    public List<TapestryPersistenceUnitInfo> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (NAMESPACE_URIS.contains(namespaceURI)) {
            if (ELEMENT_PERSISTENCE_UNIT.equals(localName)) {
                this.persistenceUnitInfo = new PersistenceUnitInfoImpl(atts.getValue(ATTRIBUTE_NAME));
                this.persistenceUnitInfo.setPersistenceXMLSchemaVersion(atts.getValue("value"));
                String transactionType = atts.getValue(ATTRIBUTE_TRANSACTION_TYPE);
                if (transactionType != null) {
                    this.persistenceUnitInfo.transactionType(PersistenceUnitTransactionType.valueOf((String)transactionType));
                }
            } else if (ELEMENT_PROPERTY.equals(localName)) {
                String name = atts.getValue(ATTRIBUTE_NAME);
                String value = atts.getValue("value");
                this.persistenceUnitInfo.getProperties().setProperty(name, value);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String string = this.characters.toString().trim();
        this.characters = null;
        if (NAMESPACE_URIS.contains(namespaceURI)) {
            if (ELEMENT_PROVIDER.equals(localName)) {
                this.persistenceUnitInfo.persistenceProviderClassName(string);
            } else if (ELEMENT_CLASS.equals(localName)) {
                this.persistenceUnitInfo.addManagedClassName(string);
            } else if (ELEMENT_CACHING.equals(localName)) {
                this.persistenceUnitInfo.sharedCacheMode(this.toEnum(SharedCacheMode.class, string));
            } else if (ELEMENT_VALIDATION_MODE.equals(localName)) {
                this.persistenceUnitInfo.validationMode(this.toEnum(ValidationMode.class, string));
            } else if (ELEMENT_MAPPING_FILE.equals(localName)) {
                this.persistenceUnitInfo.addMappingFileName(string);
            } else if (ELEMENT_JAR_FILE.equals(localName)) {
                this.persistenceUnitInfo.addJarFileUrl(string);
            } else if (ELEMENT_NON_JTA_DATA_SOURCE.equals(localName)) {
                this.persistenceUnitInfo.nonJtaDataSource(string);
            } else if (ELEMENT_JTA_DATA_SOURCE.equals(localName)) {
                this.persistenceUnitInfo.jtaDataSource(string);
            } else if (ELEMENT_PERSISTENCE_UNIT.equals(localName)) {
                if (this.persistenceUnitInfo != null) {
                    this.persistenceUnits.add(this.persistenceUnitInfo);
                    this.persistenceUnitInfo = null;
                }
            } else if (ELEMENT_EXCLUDE_UNLISTED_CLASSES.equals(localName)) {
                this.persistenceUnitInfo.excludeUnlistedClasses(Boolean.valueOf(string));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.characters == null) {
            this.characters = new StringBuilder(s);
        } else {
            this.characters.append(s);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private <T extends Enum<T>> T toEnum(Class<T> enumType, String value) {
        return Enum.valueOf(enumType, value);
    }
}

