/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import java.io.Serializable;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.hibernate.Session;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.slf4j.Logger;

public final class HibernateEntityValueEncoder<E>
implements ValueEncoder<E> {
    private final Class<E> entityClass;
    private final Session session;
    private final TypeCoercer typeCoercer;
    private final PropertyAdapter propertyAdapter;
    private final Logger logger;

    public HibernateEntityValueEncoder(Class<E> entityClass, PersistentClass persistentClass, Session session, PropertyAccess propertyAccess, TypeCoercer typeCoercer, Logger logger) {
        this.entityClass = entityClass;
        this.session = session;
        this.typeCoercer = typeCoercer;
        this.logger = logger;
        Property property = persistentClass.getIdentifierProperty();
        this.propertyAdapter = propertyAccess.getAdapter(this.entityClass).getPropertyAdapter(property.getName());
    }

    public String toClient(E value) {
        if (value == null) {
            return null;
        }
        Object id = this.propertyAdapter.get(value);
        if (id == null) {
            return null;
        }
        return (String)this.typeCoercer.coerce(id, String.class);
    }

    public E toValue(String clientValue) {
        if (InternalUtils.isBlank((String)clientValue)) {
            return null;
        }
        Object id = null;
        try {
            id = this.typeCoercer.coerce((Object)clientValue, this.propertyAdapter.getType());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception converting '%s' to instance of %s (id type for entity %s): %s", clientValue, this.propertyAdapter.getType().getName(), this.entityClass.getName(), ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
        Serializable ser = (Serializable)id;
        Object result = this.session.get(this.entityClass, ser);
        if (result == null) {
            this.logger.error(String.format("Unable to convert client value '%s' into an entity instance.", clientValue));
        }
        return (E)result;
    }
}

