/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.services.AbstractAsset;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.AssetPathConstructor;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public abstract class AbstractAssetFactory
implements AssetFactory {
    private final AssetPathConstructor assetPathConstructor;
    private final ResponseCompressionAnalyzer compressionAnalyzer;
    private final StreamableResourceSource streamableResourceSource;
    private final ResourceChangeTracker resourceChangeTracker;
    private final Resource rootResource;

    public AbstractAssetFactory(ResponseCompressionAnalyzer compressionAnalyzer, ResourceChangeTracker resourceChangeTracker, StreamableResourceSource streamableResourceSource, AssetPathConstructor assetPathConstructor, Resource rootResource) {
        this.compressionAnalyzer = compressionAnalyzer;
        this.resourceChangeTracker = resourceChangeTracker;
        this.streamableResourceSource = streamableResourceSource;
        this.assetPathConstructor = assetPathConstructor;
        this.rootResource = rootResource;
    }

    protected boolean isCompressable(StreamableResource resource) {
        return this.compressionAnalyzer.isGZipEnabled(resource.getContentType());
    }

    @Override
    public Resource getRootResource() {
        return this.rootResource;
    }

    protected Asset createAsset(final Resource resource, final String folder, final String resourcePath) {
        assert (resource != null);
        assert (InternalUtils.isNonBlank((String)folder));
        assert (InternalUtils.isNonBlank((String)resourcePath));
        return new AbstractAsset(false){

            @Override
            public String toClientURL() {
                try {
                    StreamableResource uncompressed = AbstractAssetFactory.this.streamableResourceSource.getStreamableResource(resource, StreamableResourceProcessing.COMPRESSION_DISABLED, AbstractAssetFactory.this.resourceChangeTracker);
                    StreamableResource forRequest = AbstractAssetFactory.this.isCompressable(uncompressed) ? AbstractAssetFactory.this.streamableResourceSource.getStreamableResource(resource, StreamableResourceProcessing.COMPRESSION_ENABLED, AbstractAssetFactory.this.resourceChangeTracker) : uncompressed;
                    return AbstractAssetFactory.this.assetPathConstructor.constructAssetPath(folder, resourcePath, forRequest);
                }
                catch (IOException ex) {
                    throw new RuntimeException(String.format("Unable to construct asset path for %s: %s", resource, ExceptionUtils.toMessage((Throwable)ex)), ex);
                }
            }

            @Override
            public Resource getResource() {
                return resource;
            }
        };
    }
}

